/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.eoy2013;

import com.selima.fbi.core.Agent;
import com.selima.fbi.core.Contact;
import com.selima.fbi.core.common_eoy_2012_2013.IEOYMessage2012_and_2013;
import com.selima.fbi.core.standard.AbstractEOYMessage;
import com.selima.fbi.core.standard.eoy2013.Tools;
import com.selima.fbi.core.standard.generated.paye2013.IRenvelope;
import com.selima.fbi.core.standard.generated.paye2013.IRheader;
import java.util.Date;
import java.util.Map;

public class EOY2013Message
extends AbstractEOYMessage<IRenvelope>
implements IEOYMessage2012_and_2013 {
    private final Number asppRecovered;
    private final Number asppCompensation;

    public EOY2013Message(IRenvelope envelope, byte[] bytes) {
        super(envelope, "http://www.govtalk.gov.uk/taxation/EOY/" + Tools.taxYearString(envelope) + "/1", bytes);
        this.asppRecovered = this.mapAsppRecovered(envelope);
        this.asppCompensation = this.mapAsppCompensation(envelope);
    }

    @Override
    public Number getAsppRecovered() {
        return this.asppRecovered;
    }

    @Override
    public Number getAsppCompensation() {
        return this.asppCompensation;
    }

    protected Number mapAsppCompensation(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getASPPcompensation().getValue();
    }

    protected Number mapAsppRecovered(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getASPP().getValue();
    }

    @Override
    protected Date mapCessationDate(IRenvelope envelope) {
        if (envelope.getEndOfYearReturn().getP35().getCessationDate() != null) {
            return envelope.getEndOfYearReturn().getP35().getCessationDate().toGregorianCalendar().getTime();
        }
        return null;
    }

    @Override
    protected String mapECON(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getEmployerDetails().getECON();
    }

    @Override
    protected String mapEmployerName(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getEmployerDetails().getEmployerName();
    }

    @Override
    protected int mapP14Count(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP14Count().intValue();
    }

    @Override
    protected Number mapSAP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getSAP().getValue();
    }

    @Override
    protected Number mapSMP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getSMP().getValue();
    }

    @Override
    protected Number mapSPP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getOSPP().getValue();
    }

    @Override
    protected Number mapSSP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getOSPP().getValue();
    }

    @Override
    protected Number mapTotalNIC(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getTotalNIC().getValue();
    }

    @Override
    protected Number mapTotalPayable(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getCombinedAmounts().getTotalPayable().getValue();
    }

    @Override
    protected Number mapTotalRemainingToPay(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getCombinedAmounts().getTotalRemainingToPay().getValue();
    }

    @Override
    protected Number mapTotalTax(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getPAYE().getTotalTax().getValue();
    }

    @Override
    protected void getKeys(IRenvelope envelope, Map<String, String> keyMap) {
        for (IRheader.Keys.Key key : envelope.getIRheader().getKeys().getKeies()) {
            keyMap.put(key.getType(), key.getValue());
        }
    }

    @Override
    protected Agent mapAgent(IRenvelope envelope) {
        if (envelope.getIRheader().getAgent() != null) {
            return new Agent(envelope.getIRheader().getAgent());
        }
        return null;
    }

    @Override
    protected Contact mapPrincipal(IRenvelope envelope) {
        if (envelope.getIRheader().getPrincipal() != null) {
            return new Contact(envelope.getIRheader().getPrincipal().getContact());
        }
        return null;
    }

    @Override
    protected String mapSender(IRenvelope envelope) {
        return envelope.getIRheader().getSender();
    }

    @Override
    protected boolean mapTestMessage(IRenvelope envelope) {
        return Integer.valueOf(1).equals(envelope.getIRheader().getTestMessage());
    }

    @Override
    protected int mapTaxYearEnd(IRenvelope envelope) {
        return envelope.getIRheader().getPeriodEnd().getYear();
    }
}

