/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.dps;

import com.selima.fbi.FormType;
import com.selima.fbi.core.ISL1Message;
import com.selima.fbi.core.standard.AbstractDPSMessage;
import com.selima.fbi.core.standard.generated.sl1.StudentLoanStart;
import java.util.Date;
import java.util.List;

public class StudentLoanStartDPSMessage
extends AbstractDPSMessage<StudentLoanStart>
implements ISL1Message {
    String nino;
    String worksNumber;
    String surname;
    List<String> forename;
    Date startDate;
    String planType;

    public StudentLoanStartDPSMessage(StudentLoanStart content, byte[] data) {
        super(content, "http://www.govtalk.gov.uk/taxation/StudentLoanStart/2", data);
        this.startDate = content.getLoanStartDate().toGregorianCalendar().getTime();
        this.forename = content.getName().getForename();
        this.worksNumber = content.getWorksNumber();
        this.surname = content.getName().getSurname();
        this.nino = content.getNINO();
        this.planType = content.getPlanType();
    }

    @Override
    protected long mapSequenceNumber(StudentLoanStart parsedMessage) {
        return parsedMessage.getSequenceNumber();
    }

    @Override
    protected String mapEmpRef(StudentLoanStart parsedMessage) {
        return parsedMessage.getEmployerRef();
    }

    @Override
    protected String mapSubject(StudentLoanStart parsedMessage) {
        return this.employee(parsedMessage.getName().getForename(), parsedMessage.getName().getSurname(), parsedMessage.getWorksNumber(), parsedMessage.getNINO());
    }

    @Override
    protected FormType mapFormType(StudentLoanStart parsedMessage) {
        return FormType.SL1;
    }

    @Override
    protected Date mapIssueDate(StudentLoanStart parsedMessage) {
        return parsedMessage.getIssueDate().toGregorianCalendar().getTime();
    }

    @Override
    protected String mapHMRCoffice(StudentLoanStart parsedMessage) {
        return "";
    }

    @Override
    protected int mapTaxYearEnd(StudentLoanStart parsedMessage) {
        return Integer.parseInt(parsedMessage.getTaxYearEnd());
    }

    @Override
    public String getNino() {
        return this.nino;
    }

    @Override
    public String getWorksNumber() {
        return this.worksNumber;
    }

    @Override
    public String getSurname() {
        return this.surname;
    }

    @Override
    public List<String> getForename() {
        return this.forename;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public String getPlanType() {
        return this.planType;
    }

    @Override
    public String getPayrollWarningMessage() {
        return null;
    }
}

