/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.dps;

import com.selima.fbi.FormType;
import com.selima.fbi.core.ISL2Message;
import com.selima.fbi.core.standard.AbstractDPSMessage;
import com.selima.fbi.core.standard.generated.sl2.StudentLoanEnd;
import java.util.Date;
import java.util.List;

public class StudentLoanEndDPSMessage
extends AbstractDPSMessage<StudentLoanEnd>
implements ISL2Message {
    private String nino;
    private String worksNumber;
    private String surname;
    private List<String> forename;
    private Date stopDate;

    public StudentLoanEndDPSMessage(StudentLoanEnd content, byte[] data) {
        super(content, "http://www.govtalk.gov.uk/taxation/StudentLoanEnd/2", data);
        this.worksNumber = content.getWorksNumber();
        this.forename = content.getName().getForename();
        this.surname = content.getName().getSurname();
        this.stopDate = content.getStopDate().toGregorianCalendar().getTime();
        this.nino = content.getNINO();
    }

    @Override
    protected long mapSequenceNumber(StudentLoanEnd parsedMessage) {
        return parsedMessage.getSequenceNumber();
    }

    @Override
    protected String mapEmpRef(StudentLoanEnd parsedMessage) {
        return parsedMessage.getEmployerRef();
    }

    @Override
    protected String mapSubject(StudentLoanEnd parsedMessage) {
        return this.employee(parsedMessage.getName().getForename(), parsedMessage.getName().getSurname(), parsedMessage.getWorksNumber(), parsedMessage.getNINO());
    }

    @Override
    protected FormType mapFormType(StudentLoanEnd parsedMessage) {
        return FormType.SL2;
    }

    @Override
    protected Date mapIssueDate(StudentLoanEnd parsedMessage) {
        return parsedMessage.getIssueDate().toGregorianCalendar().getTime();
    }

    @Override
    protected String mapHMRCoffice(StudentLoanEnd parsedMessage) {
        return "";
    }

    @Override
    protected int mapTaxYearEnd(StudentLoanEnd parsedMessage) {
        return Integer.parseInt(parsedMessage.getTaxYearEnd());
    }

    @Override
    public String getNino() {
        return this.nino;
    }

    @Override
    public String getWorksNumber() {
        return this.worksNumber;
    }

    @Override
    public String getSurname() {
        return this.surname;
    }

    @Override
    public List<String> getForename() {
        return this.forename;
    }

    @Override
    public Date getStopDate() {
        return this.stopDate;
    }

    @Override
    public String getPayrollWarningMessage() {
        return null;
    }
}

