/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.dps;

import com.selima.fbi.FormType;
import com.selima.fbi.core.IARmnMessage;
import com.selima.fbi.core.standard.AbstractDPSMessage;
import com.selima.fbi.core.standard.generated.armn.ReminderARmn;
import java.util.Date;
import java.util.List;

public class ReminderArmnDPSMessage
extends AbstractDPSMessage<ReminderARmn>
implements IARmnMessage {
    private String employerName;
    private String accountsOfficeReference;
    private List<String> liability;
    private Date dueDate;

    public ReminderArmnDPSMessage(ReminderARmn content, byte[] data) {
        super(content, "http://www.govtalk.gov.uk/taxation/ReminderARmn/2", data);
        this.liability = content.getEmployerDetails().getLiabilityType();
        this.dueDate = content.getEmployerDetails().getDueDate().toGregorianCalendar().getTime();
        this.employerName = content.getEmployerDetails().getName();
        this.accountsOfficeReference = content.getEmployerDetails().getAORef();
    }

    @Override
    protected long mapSequenceNumber(ReminderARmn parsedMessage) {
        return parsedMessage.getSequenceNumber();
    }

    @Override
    protected String mapEmpRef(ReminderARmn parsedMessage) {
        return parsedMessage.getEmployerDetails().getEmployerRef();
    }

    @Override
    protected String mapSubject(ReminderARmn parsedMessage) {
        int year = Integer.parseInt(parsedMessage.getTaxYearEnd());
        return "End of Year Return - Tax year " + (year - 1) + " / " + year;
    }

    @Override
    protected FormType mapFormType(ReminderARmn parsedMessage) {
        return FormType.valueOf(parsedMessage.getFormType());
    }

    @Override
    protected Date mapIssueDate(ReminderARmn parsedMessage) {
        return parsedMessage.getIssueDate().toGregorianCalendar().getTime();
    }

    @Override
    protected String mapHMRCoffice(ReminderARmn parsedMessage) {
        return parsedMessage.getEmployerDetails().getHMRCoffice().getName();
    }

    @Override
    protected int mapTaxYearEnd(ReminderARmn parsedMessage) {
        return Integer.parseInt(parsedMessage.getTaxYearEnd());
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public List<String> getLiability() {
        return this.liability;
    }

    @Override
    public String getAccountsOfficeReference() {
        return this.accountsOfficeReference;
    }

    @Override
    public String getEmployerName() {
        return this.employerName;
    }

    @Override
    public String getPayrollWarningMessage() {
        return null;
    }
}

