/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.dps;

import com.selima.fbi.FormType;
import com.selima.fbi.core.IARMessage;
import com.selima.fbi.core.standard.AbstractDPSMessage;
import com.selima.fbi.core.standard.generated.ar.ReminderAR;
import java.util.Date;
import java.util.List;

public class ReminderArDPSMessage
extends AbstractDPSMessage<ReminderAR>
implements IARMessage {
    private List<String> liability;
    private String employerName;
    private String accountsOfficeReference;

    public ReminderArDPSMessage(ReminderAR content, byte[] data) {
        super(content, "http://www.govtalk.gov.uk/taxation/ReminderAR/2", data);
        this.liability = content.getEmployerDetails().getLiabilityType();
        this.employerName = content.getEmployerDetails().getName();
        this.accountsOfficeReference = content.getEmployerDetails().getAORef();
    }

    @Override
    protected String mapEmpRef(ReminderAR parsedMessage) {
        return parsedMessage.getEmployerDetails().getEmployerRef();
    }

    @Override
    protected long mapSequenceNumber(ReminderAR parsedMessage) {
        return parsedMessage.getSequenceNumber();
    }

    @Override
    protected String mapSubject(ReminderAR parsedMessage) {
        int year = Integer.parseInt(parsedMessage.getTaxYearEnd());
        return "Employer's and Contractor's Annual Return -" + (year - 1) + " / " + year;
    }

    @Override
    protected FormType mapFormType(ReminderAR parsedMessage) {
        return FormType.valueOf(parsedMessage.getFormType());
    }

    @Override
    protected Date mapIssueDate(ReminderAR parsedMessage) {
        return parsedMessage.getIssueDate().toGregorianCalendar().getTime();
    }

    @Override
    protected String mapHMRCoffice(ReminderAR parsedMessage) {
        return parsedMessage.getEmployerDetails().getHMRCoffice().getName();
    }

    @Override
    protected int mapTaxYearEnd(ReminderAR parsedMessage) {
        return Integer.parseInt(parsedMessage.getTaxYearEnd());
    }

    @Override
    public List<String> getLiability() {
        return this.liability;
    }

    @Override
    public String getAccountsOfficeReference() {
        return this.accountsOfficeReference;
    }

    @Override
    public String getEmployerName() {
        return this.employerName;
    }

    @Override
    public String getPayrollWarningMessage() {
        return null;
    }
}

