/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.dps;

import com.selima.fbi.FormType;
import com.selima.fbi.core.IP11DbNotificationMessage;
import com.selima.fbi.core.standard.AbstractDPSMessage;
import com.selima.fbi.core.standard.generated.p11.P11DbNotif;
import java.util.Date;

public class P11DbNotifDPSMessage
extends AbstractDPSMessage<P11DbNotif>
implements IP11DbNotificationMessage {
    private String accountsOfficeReference;
    private String employerName;
    private String headerText;
    private String notificationText;

    public P11DbNotifDPSMessage(P11DbNotif content, byte[] data) {
        super(content, "http://www.govtalk.gov.uk/taxation/P11DbNotif/2", data);
        this.accountsOfficeReference = content.getEmployerDetails().getAORef();
        this.employerName = content.getEmployerDetails().getName();
        this.notificationText = content.getNotificationText();
        this.headerText = content.getHeaderText();
    }

    @Override
    protected long mapSequenceNumber(P11DbNotif parsedMessage) {
        return parsedMessage.getSequenceNumber();
    }

    @Override
    protected String mapEmpRef(P11DbNotif parsedMessage) {
        return parsedMessage.getEmployerDetails().getEmployerRef();
    }

    @Override
    protected String mapSubject(P11DbNotif parsedMessage) {
        return "Employer's Notification to Complete a Return of forms P11D";
    }

    @Override
    protected FormType mapFormType(P11DbNotif parsedMessage) {
        return FormType.valueOf(parsedMessage.getFormType());
    }

    @Override
    protected Date mapIssueDate(P11DbNotif parsedMessage) {
        return parsedMessage.getIssueDate().toGregorianCalendar().getTime();
    }

    @Override
    protected String mapHMRCoffice(P11DbNotif parsedMessage) {
        return parsedMessage.getEmployerDetails().getHMRCoffice().getName();
    }

    @Override
    protected int mapTaxYearEnd(P11DbNotif parsedMessage) {
        return Integer.parseInt(parsedMessage.getTaxYearEnd());
    }

    @Override
    public String getAccountsOfficeReference() {
        return this.accountsOfficeReference;
    }

    @Override
    public String getEmployerName() {
        return this.employerName;
    }

    @Override
    public String getHMRCOffice() {
        return this.hmrcOffice;
    }

    @Override
    public String getHeaderText() {
        return this.headerText;
    }

    @Override
    public String getNotificationText() {
        return this.notificationText;
    }

    @Override
    public String getPayrollWarningMessage() {
        return null;
    }
}

