/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.dps;

import com.selima.fbi.FormType;
import com.selima.fbi.core.IP9Message;
import com.selima.fbi.core.standard.AbstractDPSMessage;
import com.selima.fbi.core.standard.generated.p9.CodingNoticeP9;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

public class CodingNotice9DPSMessage
extends AbstractDPSMessage<CodingNoticeP9>
implements IP9Message {
    private Date effectiveDate;
    private boolean week1Month1Indicator;
    private String nino;
    private String taxCode;
    private String worksNumber;
    private String surname;
    private List<String> forename;
    private String taxRegime;

    public CodingNotice9DPSMessage(CodingNoticeP9 content, byte[] data) {
        super(content, "http://www.govtalk.gov.uk/taxation/CodingNoticeP9/2", data);
        XMLGregorianCalendar date = content.getEffectiveDate();
        this.effectiveDate = date.toGregorianCalendar().getTime();
        this.nino = content.getNINO();
        this.worksNumber = content.getWorksNumber();
        this.surname = content.getName().getSurname();
        this.forename = content.getName().getForename();
        this.taxCode = content.getCodingUpdate().getTaxCode().getValue();
        this.week1Month1Indicator = "X".equals(content.getCodingUpdate().getTaxCode().getWeek1Month1Indicator());
        this.taxRegime = content.getCodingUpdate().getTaxCode().getTaxRegime();
    }

    @Override
    protected String mapEmpRef(CodingNoticeP9 parsedMessage) {
        return parsedMessage.getEmployerRef();
    }

    @Override
    protected long mapSequenceNumber(CodingNoticeP9 parsedMessage) {
        return parsedMessage.getSequenceNumber();
    }

    @Override
    protected String mapSubject(CodingNoticeP9 parsedMessage) {
        return this.employee(parsedMessage.getName().getForename(), parsedMessage.getName().getSurname(), parsedMessage.getWorksNumber(), parsedMessage.getNINO());
    }

    @Override
    protected FormType mapFormType(CodingNoticeP9 parsedMessage) {
        return FormType.valueOf(parsedMessage.getFormType());
    }

    @Override
    protected Date mapIssueDate(CodingNoticeP9 parsedMessage) {
        return parsedMessage.getIssueDate().toGregorianCalendar().getTime();
    }

    @Override
    protected String mapHMRCoffice(CodingNoticeP9 parsedMessage) {
        return "";
    }

    @Override
    protected int mapTaxYearEnd(CodingNoticeP9 parsedMessage) {
        return Integer.parseInt(parsedMessage.getTaxYearEnd());
    }

    @Override
    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    @Override
    public String getNino() {
        return this.nino;
    }

    @Override
    public String getTaxCode() {
        return this.taxCode;
    }

    @Override
    public boolean getWeek1Month1Indicator() {
        return this.week1Month1Indicator;
    }

    @Override
    public String getWorksNumber() {
        return this.worksNumber;
    }

    @Override
    public String getSurname() {
        return this.surname;
    }

    @Override
    public List<String> getForename() {
        return this.forename;
    }

    @Override
    public String getTaxRegime() {
        return this.taxRegime;
    }

    @Override
    public String getPayrollWarningMessage() {
        return null;
    }
}

