/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard;

import com.selima.fbi.FormType;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Date;

public abstract class AbstractMailMessage<T>
implements IMailMessage {
    private final byte[] xml;
    private final int taxYearEnd;
    private final Date issueDate;
    private final FormType formType;
    private final File tmpFile;
    private final String subject;
    private final String empRef;
    private final String namespace;

    protected AbstractMailMessage(T parsedMessage, String namespace, byte[] xml) {
        block4: {
            if (xml.length > 256000) {
                File tmpFile;
                try {
                    tmpFile = File.createTempFile("fbi", ".xml");
                    tmpFile.deleteOnExit();
                    IOUtil.copy((InputStream)new ByteArrayInputStream(xml), tmpFile);
                }
                catch (IOException e) {
                    this.tmpFile = null;
                    this.xml = xml;
                    break block4;
                }
                this.tmpFile = tmpFile;
                this.xml = null;
            } else {
                this.tmpFile = null;
                this.xml = xml;
            }
        }
        this.namespace = namespace;
        this.issueDate = this.mapIssueDate(parsedMessage);
        this.formType = this.mapFormType(parsedMessage);
        this.taxYearEnd = this.mapTaxYearEnd(parsedMessage);
        this.subject = this.mapSubject(parsedMessage);
        this.empRef = this.mapEmpRef(parsedMessage);
    }

    protected abstract FormType mapFormType(T var1);

    protected abstract Date mapIssueDate(T var1);

    protected abstract String mapSubject(T var1);

    protected abstract int mapTaxYearEnd(T var1);

    protected abstract String mapEmpRef(T var1);

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public FormType getFormType() {
        return this.formType;
    }

    @Override
    public String getStoreSpace() {
        return this.empRef;
    }

    @Override
    public int getTaxYearEnd() {
        return this.taxYearEnd;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public Date getIssueDate() {
        return this.issueDate;
    }

    @Override
    public String getEmpRef() {
        return this.empRef;
    }

    @Override
    public byte[] getBytes() throws IOException {
        if (this.tmpFile != null) {
            try (RandomAccessFile fileAccess = new RandomAccessFile(this.tmpFile, "r");){
                byte[] bytes = new byte[(int)this.tmpFile.length()];
                fileAccess.readFully(bytes);
                byte[] byArray = bytes;
                return byArray;
            }
        }
        return this.xml;
    }

    @Override
    public byte[] getBytesForTransmission() throws IOException {
        return this.getBytes();
    }
}

