/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard;

import com.selima.fbi.FormType;
import com.selima.fbi.core.IEOYMessage;
import com.selima.fbi.core.standard.AbstractPAYEMessage;
import java.util.Date;

public abstract class AbstractEOYMessage<EnvelopeType>
extends AbstractPAYEMessage<EnvelopeType>
implements IEOYMessage {
    private final int p14Count;
    private final Date cessationDate;
    private final String _ECON;
    private final String employerName;
    private final Number _SAP;
    private final Number _SMP;
    private final Number _SPP;
    private final Number _SSP;
    private final Number totalNIC;
    private final Number totalPayable;
    private final Number totalRemainingToPay;
    private final Number totalTax;

    protected AbstractEOYMessage(EnvelopeType envelope, String namespace, byte[] bytes) {
        super(envelope, namespace, bytes);
        this._SAP = this.mapSAP(envelope);
        this._SMP = this.mapSMP(envelope);
        this._SPP = this.mapSPP(envelope);
        this._SSP = this.mapSSP(envelope);
        this._ECON = this.mapECON(envelope);
        this.totalTax = this.mapTotalTax(envelope);
        this.totalNIC = this.mapTotalNIC(envelope);
        this.p14Count = this.mapP14Count(envelope);
        this.totalPayable = this.mapTotalPayable(envelope);
        this.employerName = this.mapEmployerName(envelope);
        this.cessationDate = this.mapCessationDate(envelope);
        this.totalRemainingToPay = this.mapTotalRemainingToPay(envelope);
    }

    protected abstract Number mapTotalRemainingToPay(EnvelopeType var1);

    protected abstract Number mapTotalPayable(EnvelopeType var1);

    protected abstract String mapEmployerName(EnvelopeType var1);

    protected abstract Number mapTotalNIC(EnvelopeType var1);

    protected abstract Number mapTotalTax(EnvelopeType var1);

    protected abstract Date mapCessationDate(EnvelopeType var1);

    protected abstract Number mapSSP(EnvelopeType var1);

    protected abstract Number mapSPP(EnvelopeType var1);

    protected abstract Number mapSMP(EnvelopeType var1);

    protected abstract Number mapSAP(EnvelopeType var1);

    protected abstract String mapECON(EnvelopeType var1);

    protected abstract int mapP14Count(EnvelopeType var1);

    @Override
    protected final FormType mapFormType(EnvelopeType parsedMessage) {
        return FormType.EOY;
    }

    @Override
    protected final String mapSubject(EnvelopeType envelope) {
        return null;
    }

    @Override
    public Date getCessationDate() {
        return this.cessationDate;
    }

    @Override
    public String getEcon() {
        return this._ECON;
    }

    @Override
    public String getEmployerName() {
        return this.employerName;
    }

    @Override
    public int getP14Count() {
        return this.p14Count;
    }

    @Override
    public Number getSapRecovered() {
        return this._SAP;
    }

    @Override
    public Number getSmpRecovered() {
        return this._SMP;
    }

    @Override
    public Number getSppRecovered() {
        return this._SPP;
    }

    @Override
    public Number getSspRecovered() {
        return this._SSP;
    }

    @Override
    public Number getTotalNIC() {
        return this.totalNIC;
    }

    @Override
    public Number getTotalPayable() {
        return this.totalPayable;
    }

    @Override
    public Number getTotalRemainingToPay() {
        return this.totalRemainingToPay;
    }

    @Override
    public Number getTotalTax() {
        return this.totalTax;
    }
}

