/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.response;

import com.selima.fbi.crypto.Base32;
import com.selima.fbi.crypto.Base64;

public class HMRCMarkReceipt {
    final String xmlSignature;
    final String irMark;

    public HMRCMarkReceipt(String irMark, String xmlSignature) {
        this.irMark = irMark;
        this.xmlSignature = xmlSignature;
    }

    public String getIrMark() {
        return this.irMark;
    }

    public String getFormattedIrMark() {
        return HMRCMarkReceipt.getFormattedIrMark(this.irMark);
    }

    public String getXmlSignature() {
        return this.xmlSignature;
    }

    public int hashCode() {
        return this.irMark.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof HMRCMarkReceipt) {
            return this.irMark.equals(((HMRCMarkReceipt)obj).irMark);
        }
        return false;
    }

    public static String getFormattedIrMark(String value) {
        return HMRCMarkReceipt.withSpaces(Base32.encode(Base64.decode(value)));
    }

    private static String withSpaces(String text) {
        StringBuilder result = new StringBuilder(text.length() + text.length() / 4);
        for (int i = 0; i < text.length(); i += 4) {
            result.append(text.substring(i, Math.min(i + 4, text.length()))).append(' ');
        }
        return result.toString();
    }
}

