/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.payebeans.rti2021.impl;

import com.selima.fbi.core.payebeans.impl.XMLWriter;
import com.selima.fbi.core.payebeans.impl.YesType;
import com.selima.fbi.core.payebeans.rti2021.IEPSBeanMessage2021;
import com.selima.fbi.core.payebeans.rti2021.impl.EPSBeanMessage2021AndBeyond;
import com.selima.fbi.sender.ISenderDetails;
import javax.xml.stream.XMLStreamException;

public class EPSBeanMessage2021
extends EPSBeanMessage2021AndBeyond
implements IEPSBeanMessage2021 {
    Number aid;

    public EPSBeanMessage2021(int taxYear, ISenderDetails senderDetails, String empRef) {
        super("http://www.govtalk.gov.uk/taxation/PAYE/RTI/EmployerPaymentSummary/20-21/1", taxYear, senderDetails, empRef);
    }

    @Override
    public Number getAid() {
        return this.aid;
    }

    @Override
    public void setAid(Number aid) {
        this.aid = aid;
    }

    public void initAid(Number aid) {
        this.initialAid = this.aid = aid;
    }

    @Override
    public void resetAid() {
        this.aid = this.initialAid;
    }

    @Override
    protected void writePayloadToXml(XMLWriter writer) throws XMLStreamException {
        writer.openTag("EmployerPaymentSummary", new String[0]).openTag("EmpRefs", new String[0]).element("OfficeNo", this.officeNo, new String[0]).element("PayeRef", this.payeRef, new String[0]).element("AORef", this.aoRef, new String[0]).closeTag();
        if (this.noPaymentDateFrom != null || this.noPaymentDateTo != null) {
            writer.element("NoPaymentForPeriod", YesType.yes, new Object[0]).openTag("NoPaymentDates", new String[0]).dateElement("From", this.noPaymentDateFrom, new String[0]).dateElement("To", this.noPaymentDateTo, new String[0]).closeTag();
        }
        if (this.periodOfInactivityFrom != null || this.periodOfInactivityTo != null) {
            writer.openTag("PeriodOfInactivity", new String[0]).dateElement("From", this.periodOfInactivityFrom, new String[0]).dateElement("To", this.periodOfInactivityTo, new String[0]).closeTag();
        }
        writer.element("EmpAllceInd", this.empAllceInd, new Object[0]);
        if (this.agri != null || this.fisheriesAqua != null || this.roadTrans != null || this.indust != null || this.nA != null || this.aid != null) {
            writer.openTag("DeMinimisStateAid", new String[0]).element("Agri", this.agri, new Object[0]).element("FisheriesAqua", this.fisheriesAqua, new Object[0]).element("RoadTrans", this.roadTrans, new Object[0]).element("Indust", this.indust, new Object[0]).element("NA", this.nA, new Object[0]).decElement("Aid", this.aid, "Cur", "EUR").closeTag();
        }
        if (this.hasRecoverables()) {
            writer.openTag("RecoverableAmountsYTD", new String[0]).intElement("TaxMonth", this.taxMonth, new String[0]).decElement("SMPRecovered", this.smpRecovered, new String[0]).decElement("SPPRecovered", this.sppRecovered, new String[0]).decElement("SAPRecovered", this.sapRecovered, new String[0]).decElement("ShPPRecovered", this.shppRecovered, new String[0]).decElement("SPBPRecovered", this.spbpRecovered, new String[0]).decElement("NICCompensationOnSMP", this.nicCompensationOnSMP, new String[0]).decElement("NICCompensationOnSPP", this.nicCompensationOnSPP, new String[0]).decElement("NICCompensationOnSAP", this.nicCompensationOnSAP, new String[0]).decElement("NICCompensationOnShPP", this.nicCompensationOnShPP, new String[0]).decElement("NICCompensationOnSPBP", this.nicCompensationOnSPBP, new String[0]).decElement("CISDeductionsSuffered", this.cisDeductionsSuffered, new String[0]).closeTag();
        }
        if (this.levyDueYTD != null || this.apprenticeshipLevyTaxMonth != null || this.annualAllce != null) {
            writer.openTag("ApprenticeshipLevy", new String[0]).decElement("LevyDueYTD", this.levyDueYTD, new String[0]).intElement("TaxMonth", this.apprenticeshipLevyTaxMonth, new String[0]).decElement("AnnualAllce", this.annualAllce, new String[0]).closeTag();
        }
        if (this.accountHoldersName != null || this.accountNo != null || this.sortCode != null || this.buildingSocRef != null) {
            writer.openTag("Account", new String[0]).element("AccountHoldersName", this.accountHoldersName, new String[0]).element("AccountNo", this.accountNo, new String[0]).element("SortCode", this.sortCode, new String[0]).element("BuildingSocRef", this.buildingSocRef, new String[0]).closeTag();
        }
        writer.taxYearElement("RelatedTaxYear", this.getTaxYearEnd());
        if (this.finalSubmissionBecauseSchemeCeased == YesType.yes || this.finalSubmissionForYear == YesType.yes) {
            writer.openTag("FinalSubmission", new String[0]).element("BecauseSchemeCeased", this.finalSubmissionBecauseSchemeCeased, new Object[0]).dateElement("DateSchemeCeased", this.dateSchemeCeased, new String[0]).element("ForYear", this.finalSubmissionForYear, new Object[0]).closeTag();
        }
        writer.closeTag();
    }
}

