/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.payebeans.rti2020.impl;

import com.selima.fbi.core.YesNoEnum;
import com.selima.fbi.core.payebeans.impl.YesType;
import com.selima.fbi.core.payebeans.rti2020.impl.EPSBeanMessage2020;
import com.selima.fbi.core.standard.generated.eps2020.EmployerPaymentSummary;
import com.selima.fbi.core.standard.generated.eps2020.IRenvelope;
import com.selima.fbi.core.standard.generated.eps2020.IRheader;
import com.selima.fbi.sender.ParsedSenderDetails;
import java.util.HashMap;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

public class ParsedEPSBeanMessage2020
extends EPSBeanMessage2020 {
    public ParsedEPSBeanMessage2020(IRenvelope envelope) {
        super(envelope.getIRheader().getPeriodEnd().getYear(), new ParsedSenderDetails(envelope), ParsedEPSBeanMessage2020.parsedTaxRef(envelope));
        EmployerPaymentSummary employerPaymentSummary = envelope.getEmployerPaymentSummary();
        if (employerPaymentSummary != null) {
            EmployerPaymentSummary.Account account;
            EmployerPaymentSummary.FinalSubmission finalSubmission;
            EmployerPaymentSummary.PeriodOfInactivity periodOfInactivity;
            EmployerPaymentSummary.NoPaymentDates noPaymentDates;
            EmployerPaymentSummary.ApprenticeshipLevy apprenticeshipLevy;
            EmployerPaymentSummary.RecoverableAmountsYTD recoverableAmountsYTD;
            EmployerPaymentSummary.EmpRefs empRefs = employerPaymentSummary.getEmpRefs();
            if (empRefs != null) {
                this.initAORef(empRefs.getAORef());
                this.initOfficeNo(empRefs.getOfficeNo());
                this.initPayeRef(empRefs.getPayeRef());
            }
            if ((recoverableAmountsYTD = employerPaymentSummary.getRecoverableAmountsYTD()) != null) {
                String monthString = recoverableAmountsYTD.getTaxMonth();
                this.initTaxMonth(monthString != null ? Integer.valueOf(Integer.parseInt(monthString)) : null);
                this.initSppRecovered(recoverableAmountsYTD.getSPPRecovered());
                this.initCisDeductionsSuffered(recoverableAmountsYTD.getCISDeductionsSuffered());
                this.initNicCompensationOnSPP(recoverableAmountsYTD.getNICCompensationOnSPP());
                this.initNicCompensationOnShPP(recoverableAmountsYTD.getNICCompensationOnShPP());
                this.initNicCompensationOnSAP(recoverableAmountsYTD.getNICCompensationOnSAP());
                this.initNicCompensationOnSMP(recoverableAmountsYTD.getNICCompensationOnSMP());
                this.initSmpRecovered(recoverableAmountsYTD.getSMPRecovered());
                this.initShppRecovered(recoverableAmountsYTD.getShPPRecovered());
                this.initSapRecovered(recoverableAmountsYTD.getSAPRecovered());
            }
            if ((apprenticeshipLevy = employerPaymentSummary.getApprenticeshipLevy()) != null) {
                this.initLevyDueYTD(apprenticeshipLevy.getLevyDueYTD());
                String monthString = apprenticeshipLevy.getTaxMonth();
                this.initApprenticeshipLevyTaxMonth(monthString != null ? Integer.valueOf(Integer.parseInt(monthString)) : null);
                this.initAnnualAllce(apprenticeshipLevy.getAnnualAllce());
            }
            if ((noPaymentDates = employerPaymentSummary.getNoPaymentDates()) != null) {
                XMLGregorianCalendar to;
                XMLGregorianCalendar from = noPaymentDates.getFrom();
                if (from != null) {
                    this.initNoPaymentDateFrom(from.toGregorianCalendar().getTime());
                }
                if ((to = noPaymentDates.getTo()) != null) {
                    this.initNoPaymentDateTo(to.toGregorianCalendar().getTime());
                }
            }
            if ((periodOfInactivity = employerPaymentSummary.getPeriodOfInactivity()) != null) {
                XMLGregorianCalendar to;
                XMLGregorianCalendar from = periodOfInactivity.getFrom();
                if (from != null) {
                    this.initPeriodOfInactivityFrom(from.toGregorianCalendar().getTime());
                }
                if ((to = periodOfInactivity.getTo()) != null) {
                    this.initPeriodOfInactivityTo(to.toGregorianCalendar().getTime());
                }
            }
            if ((finalSubmission = employerPaymentSummary.getFinalSubmission()) != null) {
                XMLGregorianCalendar dateSchemeCeased = finalSubmission.getDateSchemeCeased();
                if (dateSchemeCeased != null) {
                    this.initDateSchemeCeased(dateSchemeCeased.toGregorianCalendar().getTime());
                }
                this.initFinalSubmissionBecauseSchemeCeased(YesType.fromJaxb(finalSubmission.getBecauseSchemeCeased()));
                this.initFinalSubmissionForYear(YesType.fromJaxb(finalSubmission.getForYear()));
            }
            if ((account = employerPaymentSummary.getAccount()) != null) {
                this.initAccountHoldersName(account.getAccountHoldersName());
                this.initAccountNo(account.getAccountNo());
                this.initSortCode(account.getSortCode());
                this.initBuildingSocRef(account.getBuildingSocRef());
            }
            this.initEmpAllceInd(YesNoEnum.valueOfJaxb((Object)employerPaymentSummary.getEmpAllceInd()));
        }
    }

    static String parsedTaxRef(IRenvelope envelope) {
        List<IRheader.Keys.Key> keys = envelope.getIRheader().getKeys().getKeies();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        for (IRheader.Keys.Key key : keys) {
            keyMap.put(key.getType(), key.getValue());
        }
        return (String)keyMap.get("TaxOfficeNumber") + "/" + (String)keyMap.get("TaxOfficeReference");
    }
}

