/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.payebeans.rti2016.impl;

import com.selima.fbi.core.payebeans.PropertyValidationException;
import com.selima.fbi.core.payebeans.rti2015.impl.EPSBeanMessage2015Beyond;
import com.selima.fbi.core.payebeans.rti2016.IEPSBeanMessage2016Beyond;
import com.selima.fbi.sender.ISenderDetails;

public abstract class EPSBeanMessage2016Beyond
extends EPSBeanMessage2015Beyond
implements IEPSBeanMessage2016Beyond {
    protected Integer taxMonth;
    private Integer initialTaxMonth;
    protected Number sppRecovered;
    private Number initialSppRecovered;
    protected Number shppRecovered;
    private Number initialShppRecovered;
    protected Number nicCompensationOnSPP;
    private Number initialNicCompensationOnSPP;
    protected Number nicCompensationOnShPP;
    private Number initialNicCompensationOnShPP;

    public EPSBeanMessage2016Beyond(String namespace, int taxYear, ISenderDetails senderDetails, String empRef) {
        super(namespace, taxYear, senderDetails, empRef);
    }

    @Override
    public Number getSppRecovered() {
        return this.sppRecovered;
    }

    public void initSppRecovered(Number ospRecovered) {
        this.initialSppRecovered = this.sppRecovered = ospRecovered;
    }

    @Override
    public void resetSppRecovered() {
        this.sppRecovered = this.initialSppRecovered;
    }

    @Override
    public void setSppRecovered(Number value) throws PropertyValidationException {
        this.checkRange("sppRecovered", value, 0.0, 9.999999999E7);
        this.sppRecovered = value;
    }

    @Override
    public Number getShppRecovered() {
        return this.shppRecovered;
    }

    public void initShppRecovered(Number shppRecovered) {
        this.initialShppRecovered = this.shppRecovered = shppRecovered;
    }

    @Override
    public void resetShppRecovered() {
        this.shppRecovered = this.initialShppRecovered;
    }

    @Override
    public void setShppRecovered(Number value) throws PropertyValidationException {
        this.checkRange("shppRecovered", value, 0.0, 9.999999999E7);
        this.shppRecovered = value;
    }

    @Override
    public void setNicCompensationOnSPP(Number value) throws PropertyValidationException {
        this.checkRange("nicCompensationOnSPP", value, 0.0, 9.999999999E7);
        this.nicCompensationOnSPP = value;
    }

    @Override
    public Number getNicCompensationOnSPP() {
        return this.nicCompensationOnSPP;
    }

    public void initNicCompensationOnSPP(Number nicCompensationOnSPP) {
        this.initialNicCompensationOnSPP = this.nicCompensationOnSPP = nicCompensationOnSPP;
    }

    @Override
    public void resetNicCompensationOnSPP() {
        this.nicCompensationOnSPP = this.initialNicCompensationOnSPP;
    }

    @Override
    public void setNicCompensationOnShPP(Number value) throws PropertyValidationException {
        this.checkRange("nicCompensationOnShPP", value, 0.0, 9.999999999E7);
        this.nicCompensationOnShPP = value;
    }

    @Override
    public Number getNicCompensationOnShPP() {
        return this.nicCompensationOnShPP;
    }

    public void initNicCompensationOnShPP(Number nicCompensationOnShPP) {
        this.initialNicCompensationOnShPP = this.nicCompensationOnShPP = nicCompensationOnShPP;
    }

    @Override
    public void resetNicCompensationOnShPP() {
        this.nicCompensationOnShPP = this.initialNicCompensationOnShPP;
    }

    @Override
    public Integer getTaxMonth() {
        return this.taxMonth;
    }

    @Override
    public void setTaxMonth(Integer value) throws PropertyValidationException {
        if (value != null && (value < 1 || value > 12)) {
            throw new PropertyValidationException("taxMonth", value, "Must be a valid month number; 1 to 12");
        }
        this.taxMonth = value;
    }

    public void initTaxMonth(Integer value) {
        this.initialTaxMonth = this.taxMonth = value;
    }

    @Override
    public void resetTaxMonth() {
        this.taxMonth = this.initialTaxMonth;
    }

    protected boolean hasRecoverables() {
        return this.smpRecovered != null || this.sppRecovered != null || this.sapRecovered != null || this.shppRecovered != null || this.nicCompensationOnSMP != null || this.nicCompensationOnSPP != null || this.nicCompensationOnSAP != null || this.nicCompensationOnShPP != null || this.cisDeductionsSuffered != null;
    }
}

