/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.payebeans.impl;

import com.selima.fbi.core.Address;
import com.selima.fbi.core.WorkHomeEnum;
import com.selima.fbi.core.YesNoEnum;
import com.selima.fbi.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLWriter {
    static XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    DecimalFormat decFormatter = new DecimalFormat("0.00");
    DecimalFormat intFormatter = new DecimalFormat("0");
    ByteArrayOutputStream bytes;
    XMLStreamWriter xmlWriter;
    String namespace;
    boolean started;

    public XMLWriter(String namespace) throws XMLStreamException {
        this(namespace, true);
    }

    public XMLWriter(String namespace, boolean emitXMLHeader) throws XMLStreamException {
        this.namespace = namespace;
        this.bytes = new ByteArrayOutputStream();
        this.xmlWriter = xmlOutputFactory.createXMLStreamWriter(this.bytes, "UTF-8");
        if (emitXMLHeader) {
            this.xmlWriter.writeStartDocument("UTF-8", "1.0");
        }
    }

    public XMLWriter openTag(String name, String ... args) throws XMLStreamException {
        this.xmlWriter.writeStartElement(name);
        if (!this.started) {
            this.started = true;
            this.xmlWriter.writeDefaultNamespace(this.namespace);
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i + 1] == null) continue;
            this.xmlWriter.writeAttribute(args[i], args[i + 1]);
        }
        return this;
    }

    public XMLWriter openTag(String name, Object ... args) throws XMLStreamException {
        return this.openTag(name, this.toString(args));
    }

    public XMLWriter closeTag() throws XMLStreamException {
        this.xmlWriter.writeEndElement();
        return this;
    }

    public XMLWriter element(String name, String text, String ... args) throws XMLStreamException {
        if (text != null) {
            this.openTag(name, args);
            this.xmlWriter.writeCharacters(text);
            this.closeTag();
        }
        return this;
    }

    public XMLWriter element(String name, String text, Object ... args) throws XMLStreamException {
        if (text != null) {
            return this.element(name, text, this.toString(args));
        }
        return this;
    }

    public XMLWriter intElement(String name, Number value, String ... args) throws XMLStreamException {
        if (value != null) {
            return this.element(name, this.intFormatter.format(value), args);
        }
        return this;
    }

    public XMLWriter byteArrayElement(String name, byte[] value, String ... args) throws XMLStreamException {
        if (value != null) {
            return this.element(name, Base64.getEncoder().encodeToString(value), args);
        }
        return this;
    }

    public XMLWriter numElement(String name, Number value, String format, String ... args) throws XMLStreamException {
        if (value != null) {
            DecimalFormat formatter = new DecimalFormat(format);
            return this.element(name, formatter.format(value), args);
        }
        return this;
    }

    public XMLWriter decElement(String name, Number value, String ... args) throws XMLStreamException {
        if (value != null) {
            return this.element(name, this.decFormatter.format(value), args);
        }
        return this;
    }

    public XMLWriter dateElement(String name, Date value, String ... args) throws XMLStreamException {
        if (value != null) {
            return this.element(name, this.dateFormatter.format(value), args);
        }
        return this;
    }

    public XMLWriter dateTimeElement(String name, Date value, String ... args) throws XMLStreamException {
        if (value != null) {
            return this.element(name, this.dateTimeFormatter.format(value), args);
        }
        return this;
    }

    public XMLWriter taxYearElement(String name, int taxYearEnd) throws XMLStreamException {
        return this.element(name, StringUtil.taxYearString(taxYearEnd), new String[0]);
    }

    public XMLWriter element(String name, Enum<?> value, Object ... args) throws XMLStreamException {
        if (value != null) {
            return this.element(name, value.toString(), this.toString(args));
        }
        return this;
    }

    public XMLWriter nameElement(String ttl, String fore1, String fore2, String sur) throws XMLStreamException {
        if (sur != null || fore1 != null) {
            return this.openTag("Name", new String[0]).element("Ttl", ttl, new String[0]).element("Fore", fore1, new String[0]).element("Fore", fore2, new String[0]).element("Sur", sur, new String[0]).closeTag();
        }
        return this;
    }

    public XMLWriter keysElement(String empRef) throws XMLStreamException {
        String number = empRef.substring(0, empRef.indexOf(47));
        String reference = empRef.substring(empRef.indexOf(47) + 1);
        return this.openTag("Keys", new String[0]).element("Key", number, "Type", "TaxOfficeNumber").element("Key", reference, "Type", "TaxOfficeReference").closeTag();
    }

    public XMLWriter telephoneElement(String number, String extension, WorkHomeEnum type, YesNoEnum mobile, YesNoEnum preferred) throws XMLStreamException {
        return this.openTag("Telephone", new Object[]{"Type", type, "Mobile", mobile, "Preferred", preferred}).element("Number", number, new String[0]).element("Extension", extension, new String[0]).closeTag();
    }

    public XMLWriter faxElement(String number, String extension, WorkHomeEnum type, YesNoEnum mobile, YesNoEnum preferred) throws XMLStreamException {
        return this.openTag("Fax", new Object[]{"Type", type, "Mobile", mobile, "Preferred", preferred}).element("Number", number, new String[0]).element("Extension", extension, new String[0]).closeTag();
    }

    public XMLWriter emailElement(String email, WorkHomeEnum type, YesNoEnum preferred) throws XMLStreamException {
        return this.element("Email", email, new Object[]{"Type", type, "Preferred", preferred});
    }

    public XMLWriter addressElement(List<String> lines, String postCode, String country) throws XMLStreamException {
        this.openTag("Address", new String[0]);
        for (String line : lines) {
            this.element("Line", line, new String[0]);
        }
        this.element("PostCode", postCode, new String[0]);
        this.element("Country", country, new String[0]);
        this.closeTag();
        return this;
    }

    public XMLWriter addressWithForeignCountryElement(List<String> lines, String postCode, String country) throws XMLStreamException {
        this.openTag("Address", new String[0]);
        for (String line : lines) {
            this.element("Line", line, new String[0]);
        }
        this.element("UKPostcode", postCode, new String[0]);
        this.element("ForeignCountry", country, new String[0]);
        this.closeTag();
        return this;
    }

    public XMLWriter addressElement(Address address) throws XMLStreamException {
        if (address != null) {
            return this.addressElement(address.getLines(), address.getPostCode(), address.getCountry());
        }
        return this;
    }

    public XMLWriter addressWithForeignCountryElement(Address address) throws XMLStreamException {
        if (address != null) {
            return this.addressWithForeignCountryElement(address.getLines(), address.getPostCode(), address.getCountry());
        }
        return this;
    }

    public byte[] toByteArray() {
        try {
            this.xmlWriter.flush();
            return this.bytes.toByteArray();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        try {
            this.xmlWriter.flush();
            return new String(this.bytes.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException();
        }
    }

    private String[] toString(Object[] args) {
        String[] textArgs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            textArgs[i] = args[i].toString();
        }
        return textArgs;
    }
}

