/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.payebeans.impl;

import com.selima.fbi.FormType;
import com.selima.fbi.core.Agent;
import com.selima.fbi.core.Contact;
import com.selima.fbi.core.Email;
import com.selima.fbi.core.SenderType;
import com.selima.fbi.core.Telephone;
import com.selima.fbi.core.payebeans.IBeanMessage;
import com.selima.fbi.core.payebeans.impl.BaseBean;
import com.selima.fbi.core.payebeans.impl.XMLWriter;
import com.selima.fbi.core.response.IErrorResponse;
import com.selima.fbi.core.response.IResponse;
import com.selima.fbi.core.response.ISuccessResponse;
import com.selima.fbi.sender.ISenderDetails;
import java.util.Date;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractBeanMessage
extends BaseBean
implements IBeanMessage {
    private String xmlNamespace;
    private String empRef;
    private SenderType sender;
    private int taxYearEnd;
    private Contact principal;
    private Agent agent;

    AbstractBeanMessage(String xmlNamespace, int taxYearEnd, ISenderDetails details, String empRef) {
        this.taxYearEnd = taxYearEnd;
        this.xmlNamespace = xmlNamespace;
        this.agent = details.getAgent();
        this.principal = details.getPrincipal();
        this.sender = details.getSenderType();
        this.empRef = empRef;
    }

    @Override
    public abstract FormType getFormType();

    protected abstract void writePayloadToXml(XMLWriter var1) throws XMLStreamException;

    @Override
    public String getNamespace() {
        return this.xmlNamespace;
    }

    @Override
    public Agent getAgent() {
        return this.agent;
    }

    @Override
    public Contact getPrincipal() {
        return this.principal;
    }

    @Override
    public String getSender() {
        return this.sender.value();
    }

    @Override
    public String getEmpRef() {
        return this.empRef;
    }

    @Override
    public int getTaxYearEnd() {
        return this.taxYearEnd;
    }

    @Override
    public byte[] getBytesForTransmission() {
        return this.getBytes();
    }

    @Override
    public byte[] getBytes() {
        return this.toXML();
    }

    private byte[] toXML() {
        try {
            XMLWriter xmlWriter = new XMLWriter(this.xmlNamespace, false);
            xmlWriter.openTag("IRenvelope", new String[0]).openTag("IRheader", new String[0]).keysElement(this.empRef).element("PeriodEnd", this.taxYearEnd + "-04-05", new String[0]);
            if (this.principal != null) {
                xmlWriter.openTag("Principal", new String[0]).openTag("Contact", new String[0]).nameElement(this.principal.getTitle(), this.principal.getForename1(), this.principal.getForename2(), this.principal.getSurname());
                for (Email email : this.principal.getEmails()) {
                    xmlWriter.emailElement(email.getValue(), email.getType(), email.getPreferred());
                }
                for (Telephone telephone : this.principal.getPhones()) {
                    xmlWriter.telephoneElement(telephone.getNumber(), telephone.getExtension(), telephone.getType(), telephone.getMobile(), telephone.getPreferred());
                }
                for (Telephone telephone : this.principal.getFaxes()) {
                    xmlWriter.faxElement(telephone.getNumber(), telephone.getExtension(), telephone.getType(), telephone.getMobile(), telephone.getPreferred());
                }
                xmlWriter.closeTag().closeTag();
            }
            if (this.agent != null) {
                xmlWriter.openTag("Agent", new String[0]).element("AgentID", this.agent.getAgentID(), new String[0]).element("Company", this.agent.getCompany(), new String[0]);
                if (this.agent.getAddress() != null) {
                    xmlWriter.addressElement(this.agent.getAddress().getLines(), this.agent.getAddress().getPostCode(), this.agent.getAddress().getCountry());
                }
                if (this.agent.getContact() != null) {
                    xmlWriter.openTag("Contact", new String[0]).nameElement(this.agent.getContact().getTitle(), this.agent.getContact().getForename1(), this.agent.getContact().getForename2(), this.agent.getContact().getSurname());
                    for (Email email : this.agent.getContact().getEmails()) {
                        xmlWriter.emailElement(email.getValue(), email.getType(), email.getPreferred());
                    }
                    for (Telephone telephone : this.agent.getContact().getPhones()) {
                        xmlWriter.telephoneElement(telephone.getNumber(), telephone.getExtension(), telephone.getType(), telephone.getMobile(), telephone.getPreferred());
                    }
                    for (Telephone telephone : this.agent.getContact().getFaxes()) {
                        xmlWriter.faxElement(telephone.getNumber(), telephone.getExtension(), telephone.getType(), telephone.getMobile(), telephone.getPreferred());
                    }
                    xmlWriter.closeTag();
                }
                xmlWriter.closeTag();
            }
            xmlWriter.element("Sender", this.sender == null ? "" : this.sender.value(), new String[0]);
            xmlWriter.closeTag();
            this.writePayloadToXml(xmlWriter);
            xmlWriter.closeTag();
            return xmlWriter.toByteArray();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getSubject() {
        return null;
    }

    @Override
    public Date getIssueDate() {
        return null;
    }

    @Override
    public String getStoreId() {
        return null;
    }

    @Override
    public String getStoreSpace() {
        return this.empRef;
    }

    @Override
    public String getCorrelationId() {
        return null;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public IErrorResponse getErrorResponse() {
        return null;
    }

    @Override
    public ISuccessResponse getSuccessResponse() {
        return null;
    }

    @Override
    public boolean isFailed() {
        return false;
    }

    @Override
    public boolean isSend() {
        return false;
    }

    @Override
    public boolean isSuccessful() {
        return false;
    }

    @Override
    public IResponse complete() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public IResponse submit() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public IResponse validate() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

