/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.payebeans;

import com.selima.fbi.core.Address;
import com.selima.fbi.core.payebeans.IBean;
import com.selima.fbi.core.payebeans.PropertyValidationException;
import com.selima.fbi.core.standard.generated.paye2013.InternationalAddressStructure;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.regex.Pattern;

public class BeanAddress
extends Address
implements IBean {
    PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public BeanAddress() {
    }

    public BeanAddress(List<String> lines, String postCode, String country) {
        this.lines = lines;
        this.postCode = postCode;
        this.country = country;
    }

    public BeanAddress(com.selima.fbi.core.standard.generated.paye2008.InternationalAddressStructure address) {
        this.lines = address.getLines();
        this.postCode = address.getPostCode();
        this.country = address.getCountry();
    }

    public BeanAddress(com.selima.fbi.core.standard.generated.paye2009.InternationalAddressStructure address) {
        this.lines = address.getLines();
        this.postCode = address.getPostCode();
        this.country = address.getCountry();
    }

    public BeanAddress(com.selima.fbi.core.standard.generated.paye2010.InternationalAddressStructure address) {
        this.lines = address.getLines();
        this.postCode = address.getPostCode();
        this.country = address.getCountry();
    }

    public BeanAddress(com.selima.fbi.core.standard.generated.paye2011.InternationalAddressStructure address) {
        this.lines = address.getLines();
        this.postCode = address.getPostCode();
        this.country = address.getCountry();
    }

    public BeanAddress(com.selima.fbi.core.standard.generated.paye2012.InternationalAddressStructure address) {
        this.lines = address.getLines();
        this.postCode = address.getPostCode();
        this.country = address.getCountry();
    }

    public BeanAddress(InternationalAddressStructure address) {
        this.lines = address.getLines();
        this.postCode = address.getPostCode();
        this.country = address.getCountry();
    }

    public void setLines(List<String> lines) throws PropertyValidationException {
        this.validateLines(lines);
        List oldValue = this.lines;
        this.lines = lines;
        this.changeSupport.firePropertyChange("lines", oldValue, lines);
    }

    protected void validateLines(List<String> lines) throws PropertyValidationException {
        if (lines == null || lines.size() < 1 || lines.size() > 4) {
            throw new PropertyValidationException("lines", lines);
        }
        Pattern pattern = Pattern.compile("[A-Za-z0-9 ~!\"@#$%&'\\(\\)\\*\\+,\\-\\./:;<=>\\?\\[\\\\\\]^_\\{\\}\u0163\u8364]{1,35}");
        for (String line : lines) {
            if (pattern.matcher(line).matches()) continue;
            throw new PropertyValidationException("lines", line);
        }
    }

    public void setPostCode(String postCode) throws PropertyValidationException {
        this.validatePostCode(postCode);
        String oldValue = this.postCode;
        this.postCode = postCode;
        this.changeSupport.firePropertyChange("postCode", oldValue, postCode);
    }

    protected void validatePostCode(String postCode) throws PropertyValidationException {
        if (postCode != null && !Pattern.matches("[A-Za-z0-9 ~!\"@#$%&'\\(\\)\\*\\+,\\-\\./:;<=>\\?\\[\\\\\\]^_\\{\\}\u0163\u8364]{1,8}", postCode)) {
            throw new PropertyValidationException("postCode", postCode);
        }
    }

    public void setCountry(String country) throws PropertyValidationException {
        if (country != null && !Pattern.matches("[A-Za-z0-9 ~!\"@#$%&'\\(\\)\\*\\+,\\-\\./:;<=>\\?\\[\\\\\\]^_\\{\\}\u0163\u8364]{1,35}", country)) {
            throw new PropertyValidationException("country", country);
        }
        String oldValue = this.country;
        this.country = country;
        this.changeSupport.firePropertyChange("country", oldValue, country);
    }

    @Override
    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(name, listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(name, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }
}

