/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.CancelabilityState;
import com.selima.fbi.Folder;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.WrappingFacade;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.wrapper.DPSMessageWrapper;
import com.selima.fbi.plugin.IPayrollPlugin;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.user.IReferenceManager;
import com.selima.fbi.user.IUser;
import com.selima.fbi.user.PayrollServerSpec;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import javax.swing.SwingUtilities;

public class TransferFacade
extends WrappingFacade {
    private volatile boolean running;
    private IReferenceManager referenceManager;
    private CancelabilityState cancelability;

    public TransferFacade(IMailServiceFacade facade, IReferenceManager referenceManager, CancelabilityState cancelability) {
        super(facade);
        this.cancelability = cancelability;
        this.referenceManager = referenceManager;
    }

    @Override
    public IMailMessage getMessage(Folder folder, String id) throws IOException, CancelException {
        IMailMessage result = super.getMessage(folder, id);
        IPayrollPlugin payrollPlugin = this.getCurrentUser().getPayrollPlugin();
        if (payrollPlugin.isTransferrable(result.getFormType())) {
            result = new TransferrableDPSMessage((IDPSMessage)result).getProxy();
        }
        return result;
    }

    @Override
    public List<IMailMessage> getMessages(Folder folder, String ... empref) throws IOException, CancelException {
        List<IMailMessage> result = super.getMessages(folder, empref);
        IPayrollPlugin payrollPlugin = this.getCurrentUser().getPayrollPlugin();
        ListIterator<IMailMessage> it = result.listIterator();
        while (it.hasNext()) {
            IDPSMessage message = (IDPSMessage)it.next();
            if (!payrollPlugin.isTransferrable(message.getFormType())) continue;
            it.set((IMailMessage)new TransferrableDPSMessage(message).getProxy());
        }
        return result;
    }

    @Override
    public void cancel() {
        if (this.running) {
            this.getCurrentUser().getPayrollPlugin().cancel();
        }
        super.cancel();
    }

    class TransferrableDPSMessage
    extends DPSMessageWrapper {
        boolean transferred;

        TransferrableDPSMessage(IDPSMessage message) {
            super(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transfer(boolean firstInBatch) throws IOException, PluginException, CancelException {
            assert (!SwingUtilities.isEventDispatchThread());
            IUser user = TransferFacade.this.getCurrentUser();
            if (user == null) {
                throw new IllegalStateException("user not logged in");
            }
            Folder folder = TransferFacade.this.getMessageFolder(this.getStoreId());
            if (folder != null && folder != Folder.TRANSFERRED) {
                try {
                    TransferFacade.this.running = true;
                    PayrollServerSpec payrollServer = TransferFacade.this.referenceManager.getPayrollServer(this.getEmpRef());
                    user.getPayrollPlugin().storeDPSMessage(payrollServer, (IDPSMessage)this.getProxy(), firstInBatch);
                    TransferFacade.this.cancelability.setSafe(false);
                    this.transferred = true;
                }
                finally {
                    TransferFacade.this.running = false;
                }
            }
        }

        @Override
        public boolean isTransferred() {
            return this.transferred;
        }

        @Override
        public boolean isTransferrable() {
            return !this.transferred;
        }
    }
}

