/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.AbstractFolderFacade;
import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.TransferDetails;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.wrapper.DPSMessageWrapper;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;

public class TransferDetailsFacade
extends AbstractFolderFacade<TransferDetails> {
    volatile boolean cancel;
    volatile boolean cancelable;

    public TransferDetailsFacade(IMailServiceFacade facade, IStorageFactory storageFactory) {
        super(facade, storageFactory);
    }

    @Override
    public IMailMessage getMessage(Folder folder, String id) throws IOException, CancelException {
        IMailMessage result = super.getMessage(folder, id);
        if (result instanceof IDPSMessage) {
            result = new TransferDetailsMessage((IDPSMessage)result).getProxy();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMailMessage> getMessages(Folder folder, String ... empref) throws IOException, CancelException {
        List<IMailMessage> result = super.getMessages(folder, empref);
        this.cancelable = this.storageFactory.isInTransaction();
        try {
            if (IDPSMessage.class.isAssignableFrom(folder.contentType())) {
                ListIterator<IMailMessage> it = result.listIterator();
                while (it.hasNext()) {
                    it.set((IMailMessage)new TransferDetailsMessage((IDPSMessage)it.next()).getProxy());
                }
            }
            List<IMailMessage> list = result;
            return list;
        }
        finally {
            this.cancelable = false;
            this.cancel = false;
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.cancel = this.cancelable;
    }

    @Override
    protected IStorage<TransferDetails> getStorage(String empRef) throws IOException, CancelException {
        return this.storageFactory.getStorage("transfer-details", empRef, TransferDetails.class);
    }

    @Override
    protected boolean isDeleteApplicable(Folder folder) {
        return folder == Folder.ARCHIVE;
    }

    class TransferDetailsMessage
    extends DPSMessageWrapper {
        Date transferDate;

        public TransferDetailsMessage(IDPSMessage message) throws IOException, CancelException {
            super(message);
            if (message.isTransferred()) {
                IStorage<TransferDetails> storage = TransferDetailsFacade.this.getStorage(this.getEmpRef());
                if (TransferDetailsFacade.this.cancel) {
                    throw new CancelException();
                }
                if (storage.contains(this.getStoreId())) {
                    if (TransferDetailsFacade.this.cancel) {
                        throw new CancelException();
                    }
                    this.transferDate = storage.load(this.getStoreId()).getTransferDate();
                }
            }
        }

        @Override
        public Date getTransferDate() {
            return this.transferDate;
        }

        @Override
        public void transfer(boolean firstInBatch) throws IOException, PluginException, CancelException {
            super.transfer(firstInBatch);
            this.transferDate = new Date();
            TransferDetailsFacade.this.getStorage(this.getEmpRef()).store(new TransferDetails(this.getStoreId(), this.getStoreSpace(), this.transferDate));
        }
    }
}

