/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.AbstractFolderFacade;
import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.State;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.wrapper.DPSMessageWrapper;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import javax.swing.SwingUtilities;

public class ReadStateFacade
extends AbstractFolderFacade<State> {
    private volatile boolean cancel;
    private volatile boolean cancelable;

    public ReadStateFacade(IMailServiceFacade facade, IStorageFactory storageFactory) {
        super(facade, storageFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMailMessage> getMessages(Folder folder, String ... empref) throws IOException, CancelException {
        List<IMailMessage> result = super.getMessages(folder, empref);
        if (folder.contentType() == IDPSMessage.class) {
            this.cancelable = this.storageFactory.isInTransaction();
            try {
                ListIterator<IMailMessage> it = result.listIterator();
                while (it.hasNext()) {
                    if (this.cancel) {
                        throw new CancelException();
                    }
                    it.set((IMailMessage)new ReadStateDPSMessage((IDPSMessage)it.next()).getProxy());
                }
            }
            finally {
                this.cancelable = false;
                this.cancel = false;
            }
        }
        return result;
    }

    @Override
    public IMailMessage getMessage(Folder folder, String id) throws IOException, CancelException {
        IMailMessage result = super.getMessage(folder, id);
        if (folder.contentType() == IDPSMessage.class) {
            result = new ReadStateDPSMessage((IDPSMessage)result).getProxy();
        }
        return result;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.cancel = this.cancelable;
    }

    @Override
    protected IStorage<State> getStorage(String empRef) throws IOException, CancelException {
        return this.storageFactory.getStorage("state", empRef, State.class);
    }

    @Override
    protected boolean isDeleteApplicable(Folder folder) {
        return folder == Folder.ARCHIVE;
    }

    class ReadStateDPSMessage
    extends DPSMessageWrapper {
        public ReadStateDPSMessage(IDPSMessage message) throws IOException, CancelException {
            super(message);
            IStorage<State> storage = ReadStateFacade.this.getStorage(this.getStoreSpace());
            if (storage.contains(this.getStoreId())) {
                super.markRead();
            }
        }

        @Override
        public void markRead() throws IOException, CancelException {
            assert (!SwingUtilities.isEventDispatchThread());
            if (!this.isRead()) {
                super.markRead();
                IStorage<State> storage = ReadStateFacade.this.getStorage(this.getStoreSpace());
                storage.store(new State(this.getStoreId(), this.getStoreSpace(), true));
            }
        }
    }
}

