/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.ProxySettingsException;
import com.selima.fbi.WrappingFacade;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.user.IProxySettings;
import com.selima.fbi.user.IUser;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;

public class ProxyFacade
extends WrappingFacade {
    public ProxyFacade(IMailServiceFacade facade) {
        super(facade);
    }

    @Override
    public boolean logon(IUser user) throws DPSException, RemoteException, IOException, CancelException {
        this.setupProxy(user.getProxySettings());
        try {
            boolean bl = super.logon(user);
            return bl;
        }
        catch (IOException e) {
            ProxySettingsException.checkProxyError(e);
            throw e;
        }
        finally {
            IUser currentUser = this.getCurrentUser();
            if (currentUser != null) {
                if (currentUser != user) {
                    this.setupProxy(currentUser.getProxySettings());
                }
            } else {
                this.clearProxy();
            }
        }
    }

    @Override
    public IMailMessage getMessage(Folder folder, String id) throws IOException, CancelException {
        try {
            this.setupProxy(this.getCurrentUser().getProxySettings());
            return super.getMessage(folder, id);
        }
        catch (IOException e) {
            ProxySettingsException.checkProxyError(e);
            throw e;
        }
    }

    @Override
    public Folder getMessageFolder(String id) throws IOException, CancelException {
        try {
            this.setupProxy(this.getCurrentUser().getProxySettings());
            return super.getMessageFolder(id);
        }
        catch (IOException e) {
            ProxySettingsException.checkProxyError(e);
            throw e;
        }
    }

    @Override
    public List<IMailMessage> getMessages(Folder folder, String ... empref) throws IOException, CancelException {
        try {
            this.setupProxy(this.getCurrentUser().getProxySettings());
            return super.getMessages(folder, empref);
        }
        catch (IOException e) {
            ProxySettingsException.checkProxyError(e);
            throw e;
        }
    }

    @Override
    public boolean testConnection(IProxySettings proxy) throws CancelException, IOException {
        this.setupProxy(proxy);
        try {
            boolean bl = super.testConnection(proxy);
            return bl;
        }
        catch (RemoteException e) {
            ProxySettingsException.checkProxyError(e);
            throw e;
        }
        catch (IOException e) {
            ProxySettingsException.checkProxyError(e);
            throw e;
        }
        finally {
            this.setupProxy(this.getCurrentUser().getProxySettings());
        }
    }

    void setupProxy(IProxySettings settings) {
        if (!settings.isEmpty()) {
            this.setSystemProperty("http.proxyHost", settings.getProxyHost());
            this.setSystemProperty("http.proxyPort", settings.getProxyPort());
            this.setSystemProperty("http.proxyUser", settings.getProxyUser());
            this.setSystemProperty("http.proxyPassword", settings.getProxyPassword());
        } else {
            this.clearProxy();
        }
    }

    private void clearProxy() {
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("http.proxyUser");
        System.clearProperty("http.proxyPassword");
    }

    private void setSystemProperty(String name, Object value) {
        if (value != null) {
            System.setProperty(name, value.toString());
        } else {
            System.clearProperty(name);
        }
    }

    @Override
    public boolean verifyAccess(String empref) throws DPSException, RemoteException, CancelException, IOException {
        this.setupProxy(this.getCurrentUser().getProxySettings());
        try {
            return super.verifyAccess(empref);
        }
        catch (RemoteException e) {
            ProxySettingsException.checkProxyError(e);
            throw e;
        }
        catch (IOException e) {
            ProxySettingsException.checkProxyError(e);
            throw e;
        }
    }

    @Override
    public boolean verifyAccess(IProxySettings settings, String empref) throws CancelException, IOException {
        this.setupProxy(settings);
        try {
            boolean bl = super.verifyAccess(empref);
            return bl;
        }
        catch (RemoteException e) {
            ProxySettingsException.checkProxyError(e);
            throw e;
        }
        catch (IOException e) {
            ProxySettingsException.checkProxyError(e);
            throw e;
        }
        finally {
            this.setupProxy(this.getCurrentUser().getProxySettings());
        }
    }
}

