/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.AbstractSubmissionFacade;
import com.selima.fbi.CancelException;
import com.selima.fbi.CancelabilityState;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.NetworkTracker;
import com.selima.fbi.core.SubmitClass;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.service.IMailService;
import com.selima.fbi.submission.SubmitException;
import com.selima.fbi.submission.SubmitStoppedException;
import com.selima.fbi.submission.core.body.IStatusReport;
import com.selima.fbi.submission.exception.ErrorResponseException;
import com.selima.fbi.user.IUser;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class PAYEStatusReportFacade
extends AbstractSubmissionFacade {
    public PAYEStatusReportFacade(IMailServiceFacade facade, IMailService service, NetworkTracker networkTracker, CancelabilityState cancelability) {
        super(facade, service, networkTracker, cancelability);
    }

    protected PAYEStatusReportFacade(IMailServiceFacade facade, IMailService service) {
        this(facade, service, new NetworkTracker(), new CancelabilityState());
    }

    @Override
    public boolean logon(IUser user) throws DPSException, RemoteException, IOException, CancelException {
        boolean result = super.logon(user);
        if (result && !this.isOffline()) {
            try {
                GregorianCalendar calendar = new GregorianCalendar();
                ((Calendar)calendar).add(5, -1);
                this.submissionProcessor.getStatusReport(SubmitClass.IR_PAYE_EOY.toString(), calendar.getTime(), new Date());
            }
            catch (ErrorResponseException e) {
                if (e.getMessage().contains("Gateway fatal 1046:  Authentication Failure.")) {
                    LogAPI.logInfo((String)("Govermental Gateway: Password failure for " + user.getLogin() + ": case-sensitivity"));
                    return false;
                }
            }
            catch (SubmitException e) {
                LogAPI.logSevere((Throwable)e);
            }
            catch (ConnectException e) {
                return false;
            }
        }
        return result;
    }

    @Override
    public IStatusReport getPAYEStatusReport(SubmitClass submitClass, Date startDate, Date endDate) throws IOException, CancelException, SubmitException {
        try {
            return this.submissionProcessor.getStatusReport(submitClass.toString(), startDate, endDate);
        }
        catch (SubmitStoppedException e) {
            throw new CancelException();
        }
    }
}

