/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.FormType;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.WrappingFacade;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.plugin.IPayrollPluginListener;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.sender.ISenderDetails;
import com.selima.fbi.sender.ISenderDetailsSource;
import com.selima.fbi.user.IReferenceManager;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class PAYERetriveFacade
extends WrappingFacade {
    private EventBroadcast<IPayrollPluginListener> listeners = EventBroadcastFactory.createEventBroadcast(IPayrollPluginListener.class);
    private IReferenceManager referenceManager;
    private ISenderDetailsSource detailsSource;
    private volatile boolean running;

    public PAYERetriveFacade(IMailServiceFacade facade, ISenderDetailsSource detailsSource, IReferenceManager referenceManager) {
        super(facade);
        this.detailsSource = detailsSource;
        this.referenceManager = referenceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IPAYEMessage> getPAYEMessages(FormType formType, int taxYear, String ... empRefs) throws IOException, PluginException, CancelException {
        this.running = true;
        try {
            LinkedList<IPAYEMessage> result = new LinkedList<IPAYEMessage>();
            ((IPayrollPluginListener)this.listeners.getListener()).registerNumOfRuns(empRefs.length);
            for (String empRef : empRefs) {
                ISenderDetails details = this.detailsSource.getSenderDetailsForEmpRef(empRef);
                PayrollServerSpec payrollServer = this.referenceManager.getPayrollServer(empRef);
                result.addAll(this.getCurrentUser().getPayrollPlugin().retrievePAYEMessages(payrollServer, formType, taxYear, details, empRef));
            }
            LinkedList<IPAYEMessage> linkedList = result;
            return linkedList;
        }
        finally {
            this.running = false;
        }
    }

    @Override
    public void cancel() {
        if (this.running) {
            this.getCurrentUser().getPayrollPlugin().cancel();
        }
        super.cancel();
    }

    @Override
    public void addPayrollPluginListener(IPayrollPluginListener listener) {
        this.listeners.addListener((Object)listener);
        super.addPayrollPluginListener(listener);
    }

    @Override
    public void removePayrollPluginListener(IPayrollPluginListener listener) {
        this.listeners.removeListener((Object)listener);
        super.removePayrollPluginListener(listener);
    }
}

