/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.AbstractSubmissionFacade;
import com.selima.fbi.CancelException;
import com.selima.fbi.CancelabilityState;
import com.selima.fbi.FormType;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.NetworkTracker;
import com.selima.fbi.core.Agent;
import com.selima.fbi.core.Contact;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.PAYESubmissionDetails;
import com.selima.fbi.core.SubmitClass;
import com.selima.fbi.core.response.ErrorResponse;
import com.selima.fbi.core.response.IErrorResponse;
import com.selima.fbi.core.response.IResponse;
import com.selima.fbi.core.response.IStorableResponse;
import com.selima.fbi.core.response.ISuccessResponse;
import com.selima.fbi.core.response.SuccessResponse;
import com.selima.fbi.core.wrapper.ExtendedPAYEMessageWrapper;
import com.selima.fbi.service.IMailService;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.submission.ISubmitResult;
import com.selima.fbi.submission.SubmitException;
import com.selima.fbi.submission.SubmitStoppedException;
import java.io.IOException;
import java.util.Date;

public class PAYECompletingFacade
extends AbstractSubmissionFacade {
    private IStorageFactory storageFactory;

    public PAYECompletingFacade(IMailServiceFacade facade, IMailService service, IStorageFactory storageFactory, NetworkTracker networkTracker, CancelabilityState cancelability) throws IOException {
        super(facade, service, networkTracker, cancelability);
        this.storageFactory = storageFactory;
    }

    protected PAYECompletingFacade(IMailServiceFacade facade, IMailService service, IStorageFactory storageFactory) throws IOException {
        this(facade, service, storageFactory, new NetworkTracker(), new CancelabilityState());
    }

    @Override
    public IPAYEMessage getPAYEMessage(SubmitClass submitClass, String correlationID) throws IOException, CancelException {
        IPAYEMessage message = super.getPAYEMessage(submitClass, correlationID);
        if (message != null) {
            return (IPAYEMessage)new CompletingPAYEMessage(message, submitClass).getProxy();
        }
        return new UnknownPAYEMessage(submitClass, correlationID);
    }

    IStorage<PAYESubmissionDetails> getDetailsStorage(String empRef) throws IOException, CancelException {
        return this.storageFactory.getStorage("paye-details", empRef, PAYESubmissionDetails.class);
    }

    IStorage<IStorableResponse> getResponseStorage(String empRef) throws IOException, CancelException {
        return this.storageFactory.getStorage("paye-response", empRef, IStorableResponse.class);
    }

    class CompletingPAYEMessage
    extends ExtendedPAYEMessageWrapper {
        final SubmitClass submitClass;

        public CompletingPAYEMessage(IPAYEMessage payeMessage, SubmitClass submitClass) {
            super(payeMessage);
            this.submitClass = submitClass;
        }

        @Override
        public IResponse complete() throws IOException, CancelException, SubmitException {
            boolean eligibleToSave = true;
            try {
                IStorableResponse storableResponse;
                ISubmitResult result = PAYECompletingFacade.this.submissionProcessor.complete(this, this.submitClass);
                this.issueDate = result.getIssueDate();
                IResponse response = result.getResponse();
                if (response instanceof IErrorResponse) {
                    storableResponse = new ErrorResponse((IErrorResponse)response, this.getStoreId(), this.getStoreSpace());
                    this.errorResponse = storableResponse;
                    PAYECompletingFacade.this.getResponseStorage(this.getStoreSpace()).store(storableResponse);
                }
                if (response instanceof ISuccessResponse) {
                    storableResponse = new SuccessResponse((ISuccessResponse)response, this.getStoreId(), this.getStoreSpace());
                    this.successResponse = storableResponse;
                    PAYECompletingFacade.this.getResponseStorage(this.getStoreSpace()).store(storableResponse);
                }
                IResponse iResponse = this.isSuccessful() ? this.getSuccessResponse() : this.getErrorResponse();
                return iResponse;
            }
            catch (SubmitException e) {
                if (e.getCorrelationID() != null) {
                    this.issueDate = e.getIssueDate();
                    this.errorMessage = e.getMessage();
                } else {
                    eligibleToSave = false;
                }
                if (e instanceof SubmitStoppedException) {
                    throw new CancelException();
                }
                throw e;
            }
            finally {
                if (eligibleToSave) {
                    PAYECompletingFacade.this.getDetailsStorage(this.getStoreSpace()).store(new PAYESubmissionDetails(this.getStoreSpace(), this.getStoreId(), this.getIssueDate(), this.getCorrelationId(), this.getErrorMessage(), this.submitClass));
                }
            }
        }
    }

    class UnknownPAYEMessage
    implements IPAYEMessage {
        String correlationId;
        String errorMessage;
        ISuccessResponse successResponse;
        IErrorResponse errorResponse;
        SubmitClass submitClass;
        Date issueDate;

        UnknownPAYEMessage(SubmitClass submitClass, String correlationId) {
            this.correlationId = correlationId;
            this.submitClass = submitClass;
        }

        @Override
        public IResponse complete() throws CancelException, SubmitException, IOException {
            try {
                ISubmitResult result = PAYECompletingFacade.this.submissionProcessor.complete(this, this.submitClass);
                this.issueDate = result.getIssueDate();
                IResponse response = result.getResponse();
                if (response instanceof IErrorResponse) {
                    this.errorResponse = (IErrorResponse)response;
                }
                if (response instanceof ISuccessResponse) {
                    this.successResponse = (ISuccessResponse)response;
                }
                return response;
            }
            catch (SubmitException e) {
                if (e.getCorrelationID() != null) {
                    this.issueDate = e.getIssueDate();
                    this.errorMessage = e.getMessage();
                }
                if (e instanceof SubmitStoppedException) {
                    throw new CancelException();
                }
                throw e;
            }
        }

        @Override
        public Agent getAgent() {
            return null;
        }

        @Override
        public String getCorrelationId() {
            return this.correlationId;
        }

        @Override
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public IErrorResponse getErrorResponse() {
            return this.errorResponse;
        }

        @Override
        public Contact getPrincipal() {
            return null;
        }

        @Override
        public String getSender() {
            return null;
        }

        @Override
        public ISuccessResponse getSuccessResponse() {
            return this.successResponse;
        }

        @Override
        public boolean isFailed() {
            return this.errorResponse != null;
        }

        @Override
        public boolean isSend() {
            return true;
        }

        @Override
        public boolean isSuccessful() {
            return this.successResponse != null;
        }

        @Override
        public IResponse submit() {
            return null;
        }

        @Override
        public IResponse validate() {
            return null;
        }

        @Override
        public byte[] getBytes() {
            return new byte[0];
        }

        @Override
        public byte[] getBytesForTransmission() {
            return this.getBytes();
        }

        @Override
        public String getEmpRef() {
            return "XXX/XXXX";
        }

        @Override
        public FormType getFormType() {
            return FormType.UKNOWN;
        }

        @Override
        public Date getIssueDate() {
            return this.issueDate;
        }

        @Override
        public String getSubject() {
            return "Unknown";
        }

        @Override
        public int getTaxYearEnd() {
            return 0;
        }

        @Override
        public String getStoreId() {
            return null;
        }

        @Override
        public String getStoreSpace() {
            return null;
        }

        public String getValidationURL() {
            return null;
        }

        public SubmitClass getSubmitClass() {
            return this.submitClass;
        }

        @Override
        public String getNamespace() {
            return null;
        }
    }
}

