/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.DPSFacade;
import com.selima.fbi.NetworkListener;
import com.selima.fbi.NetworkTracker;
import com.selima.fbi.gotvalue.IGotValueManager;
import com.selima.fbi.service.IDpsAuthenticationClient;
import com.selima.fbi.service.IDpsClient;
import com.selima.fbi.service.IMailService;
import com.selima.fbi.service.MailServiceException;
import com.selima.fbi.storage.IStorageFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class OfflineDPSFacade
extends DPSFacade {
    final NetworkTracker networkTracker;

    public OfflineDPSFacade(IMailService service, IGotValueManager gotManager, NetworkTracker networkTracker) throws MailServiceException {
        super(service, gotManager);
        this.networkTracker = networkTracker;
        this.init();
    }

    public OfflineDPSFacade(IMailService service, IStorageFactory storageFactory, NetworkTracker networkTracker) throws MailServiceException {
        super(service, storageFactory);
        this.networkTracker = networkTracker;
        this.init();
    }

    protected OfflineDPSFacade(IMailService mailService, IGotValueManager gotManager) throws MailServiceException {
        this(mailService, gotManager, new NetworkTracker());
    }

    @Override
    public void addNetworkListener(NetworkListener listener) {
        super.addNetworkListener(listener);
        this.networkTracker.addNetworkListener(listener);
    }

    @Override
    public void removeNetworkListener(NetworkListener listener) {
        super.removeNetworkListener(listener);
        this.networkTracker.removeNetworkListener(listener);
    }

    private void init() {
        this.dpsClient = this.newOfflineDetectingClient(this.dpsClient, IDpsClient.class);
        this.authenticationClient = this.newOfflineDetectingClient(this.authenticationClient, IDpsAuthenticationClient.class);
    }

    @Override
    public boolean isOffline() {
        return this.networkTracker.isOffline();
    }

    <T> T newOfflineDetectingClient(T client, Class<T> target) {
        return target.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{target}, (InvocationHandler)new ConnectExceptionHandler(client)));
    }

    class ConnectExceptionHandler
    implements InvocationHandler {
        Object target;

        ConnectExceptionHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                OfflineDPSFacade.this.networkTracker.checkBeforeCommunication();
                Object result = method.invoke(this.target, args);
                OfflineDPSFacade.this.networkTracker.checkAfterCommunication();
                return result;
            }
            catch (InvocationTargetException e) {
                OfflineDPSFacade.this.networkTracker.checkOnError(e);
                throw e.getCause();
            }
        }
    }
}

