/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.NetworkListener;
import com.selima.fbi.util.NetUtil;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;

public class NetworkTracker {
    private State state = State.OFFLINE;
    private EventBroadcast<NetworkListener> netListeners = EventBroadcastFactory.createEventBroadcast(NetworkListener.class);

    public void addNetworkListener(NetworkListener listener) {
        this.netListeners.addListener((Object)listener);
    }

    public void removeNetworkListener(NetworkListener listener) {
        this.netListeners.removeListener((Object)listener);
    }

    public void checkBeforeCommunication() {
        if (this.state == State.OFFLINE) {
            this.state = State.CONNECTING;
            ((NetworkListener)this.netListeners.getListener()).connecting();
        }
    }

    public void checkAfterCommunication() {
        if (this.state == State.CONNECTING) {
            this.state = State.ONLINE;
            ((NetworkListener)this.netListeners.getListener()).online();
        }
    }

    public void checkOnError(Throwable tw) {
        if (NetUtil.isConnectivityProblem(tw)) {
            if (this.state != State.OFFLINE) {
                this.state = State.OFFLINE;
                ((NetworkListener)this.netListeners.getListener()).offline();
            }
        } else if (this.state != State.ONLINE) {
            this.state = State.ONLINE;
            ((NetworkListener)this.netListeners.getListener()).online();
        }
    }

    public boolean isOffline() {
        return this.state == State.OFFLINE;
    }

    private static enum State {
        OFFLINE,
        CONNECTING,
        ONLINE;

    }
}

