/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.MailServiceListenerAdapter;
import com.selima.fbi.MalformedMessage;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Frame;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;

public class MalformedMessageHandler
extends MailServiceListenerAdapter {
    List<MalformedMessage> malformedMessages;
    IStorageFactory storageFactory;
    String dialogTitle;

    public MalformedMessageHandler(String dialogTitle, IStorageFactory factory) {
        this.dialogTitle = dialogTitle;
        this.storageFactory = factory;
    }

    @Override
    public void malformedMessage(String message, Element element) {
        String formType = this.formType(element);
        String sequenceNumber = this.sequenceNumber(element);
        MalformedMessage malformedMessage = new MalformedMessage(formType, sequenceNumber, message);
        this.malformedMessages.add(malformedMessage);
        this.storeMalformedMessage(malformedMessage);
    }

    private String formType(Element element) {
        return element.getAttribute("FormType");
    }

    private String sequenceNumber(Element element) {
        return element.getAttribute("SequenceNumber");
    }

    private void storeMalformedMessage(MalformedMessage message) {
        try {
            IStorage<MalformedMessage> storage = this.storageFactory.getStorage("malformed", MalformedMessage.class);
            while (storage.contains(message.getStoreId())) {
                message.incrementStoreId();
            }
            storage.store(message);
        }
        catch (IOException e) {
            LogAPI.logSevere((Throwable)e);
        }
        catch (CancelException e) {
            LogAPI.logWarning((Throwable)e);
        }
    }

    CharSequence prepareMessage() {
        StringBuilder result = new StringBuilder().append("<html><h3>Invalid Message(s) received</h3><font color='olive'><ul>");
        int count = 0;
        for (MalformedMessage message : this.malformedMessages) {
            result.append("<li>").append(message.getStoreId()).append("</li>");
            if (++count != 15) continue;
            result.append("<li>").append(this.malformedMessages.size() - 15).append(" more</li>");
            break;
        }
        result.append("</ul></font><div style='width:275px'>Invalid messages are saved into <b>" + this.storageFactory.getName() + "/malformed</b> folder (or datafile) for further examination. Please contact technical support.</div></html>");
        return result;
    }

    @Override
    public void downloadFinished() {
        if (this.malformedMessages.size() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(MalformedMessageHandler.this.getParentWindow(), MalformedMessageHandler.this.prepareMessage(), MalformedMessageHandler.this.dialogTitle, 2);
                }
            });
        }
    }

    @Override
    public void downloadStarted(int sum) {
        this.malformedMessages = new LinkedList<MalformedMessage>();
    }

    private Frame getParentWindow() {
        Frame[] frames = Frame.getFrames();
        if (frames.length > 0) {
            return frames[frames.length - 1];
        }
        return null;
    }
}

