/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.DPSType;
import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.core.SubmitClass;
import java.util.Arrays;

public enum FormType {
    P6,
    P6B,
    P9,
    AR1n,
    AR2n,
    AR6,
    ARmn,
    AR1mn,
    AR2mn,
    ILEA,
    ILEB,
    ILEC,
    ILED,
    P11Db,
    P35Not,
    NOT,
    NVR,
    GEN,
    SL1,
    SL2,
    PGL1,
    PGL2,
    P14Part,
    P35Part,
    EOY,
    P45Part1,
    P45Part3,
    P46,
    PENNOT,
    WNU,
    EAS,
    EPS,
    FPS,
    EYU,
    NINOVR,
    UKNOWN;


    public boolean isIncomming() {
        return !this.isOutgoing();
    }

    public boolean isOutgoing() {
        return Arrays.asList(P14Part, P35Part, EOY, P45Part1, P45Part3, P46, PENNOT, WNU, EAS, EPS, FPS, EYU, NINOVR, UKNOWN).contains((Object)this);
    }

    public DPSType getDPSType() {
        switch (this) {
            case AR1n: 
            case AR2n: 
            case AR6: 
            case ARmn: 
            case AR1mn: 
            case AR2mn: {
                return DPSType.AR;
            }
            case ILEA: 
            case ILEB: 
            case ILEC: 
            case ILED: 
            case P11Db: 
            case P35Not: {
                return DPSType.NOT;
            }
            case NOT: 
            case NVR: 
            case GEN: {
                return DPSType.RTI;
            }
            case P6: 
            case P6B: {
                return DPSType.P6;
            }
            case P9: {
                return DPSType.P9;
            }
            case SL1: {
                return DPSType.SL1;
            }
            case SL2: {
                return DPSType.SL2;
            }
            case PGL1: {
                return DPSType.PGL1;
            }
            case PGL2: {
                return DPSType.PGL2;
            }
        }
        return null;
    }

    public SubmitClass getSubmitClass(boolean validation) {
        boolean testInLive = validation || MailServiceConfig.isDevelopmentVersion();
        switch (this) {
            case EAS: {
                return testInLive ? SubmitClass.HMRC_PAYE_RTI_EAS_TIL : SubmitClass.HMRC_PAYE_RTI_EAS;
            }
            case EPS: {
                return testInLive ? SubmitClass.HMRC_PAYE_RTI_EPS_TIL : SubmitClass.HMRC_PAYE_RTI_EPS;
            }
            case FPS: {
                return testInLive ? SubmitClass.HMRC_PAYE_RTI_FPS_TIL : SubmitClass.HMRC_PAYE_RTI_FPS;
            }
            case NINOVR: {
                return testInLive ? SubmitClass.HMRC_PAYE_RTI_NVR_TIL : SubmitClass.HMRC_PAYE_RTI_NVR;
            }
            case EYU: {
                return testInLive ? SubmitClass.HMRC_PAYE_RTI_EYU_TIL : SubmitClass.HMRC_PAYE_RTI_EYU;
            }
        }
        throw new IllegalArgumentException(this.name());
    }
}

