/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.CancelableDPSFacade;
import com.selima.fbi.NetworkTracker;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.service.IDpsAuthenticationClient;
import com.selima.fbi.service.IDpsClient;
import com.selima.fbi.service.IMailService;
import com.selima.fbi.service.MailServiceException;
import com.selima.fbi.storage.IStorageFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class DurableDPSFacade
extends CancelableDPSFacade {
    public DurableDPSFacade(IMailService service, IStorageFactory storageFactory, NetworkTracker networkTracker) throws MailServiceException {
        super(service, storageFactory, networkTracker);
        this.init();
    }

    private void init() {
        this.authenticationClient = this.newRepeatingClient(this.authenticationClient, IDpsAuthenticationClient.class);
        this.dpsClient = this.newRepeatingClient(this.dpsClient, IDpsClient.class);
    }

    <T> T newRepeatingClient(T client, Class<T> type) {
        return type.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{type}, (InvocationHandler)new RepeatingHandler(client)));
    }

    static class RepeatingHandler
    implements InvocationHandler {
        Object target;

        RepeatingHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Throwable cause = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    Object result = method.invoke(this.target, args);
                    return result;
                }
                catch (InvocationTargetException e) {
                    cause = e.getCause();
                    if (cause instanceof DPSException) {
                        throw cause;
                    }
                    if (!(cause instanceof CancelException)) continue;
                    throw cause;
                }
            }
            throw cause;
        }
    }
}

