/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.WrappingFacade;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.user.IUser;
import com.selima.fbi.user.IUserManager;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class AgentFacade
extends WrappingFacade {
    IUserManager userManager;

    public AgentFacade(IMailServiceFacade facade, IUserManager userManager) {
        super(facade);
        this.userManager = userManager;
    }

    @Override
    public boolean logon(IUser user) throws DPSException, RemoteException, IOException, CancelException {
        boolean isNewUser = this.userManager.getUser(user.getLogin()) == null;
        boolean result = super.logon(user);
        if (result && isNewUser) {
            try {
                user.setAgent(super.verifyAccess(""));
                this.userManager.saveUser(user);
            }
            catch (CancelException e) {
                return false;
            }
        }
        return result;
    }

    @Override
    public List<IMailMessage> getMessages(Folder folder, String ... empref) throws IOException, CancelException {
        if (empref.length == 0 && !this.getCurrentUser().isAgent() && (empref = this.getCurrentUser().getEmpRef()).length == 0) {
            return new ArrayList<IMailMessage>();
        }
        return super.getMessages(folder, empref);
    }
}

