/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.AbstractFolderFacade;
import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import java.io.IOException;
import java.util.List;

public abstract class AbstractSimpleFolderFacade<MessageType extends IMailMessage>
extends AbstractFolderFacade<MessageType> {
    protected Class<MessageType> messageType;
    protected Folder folder;

    public AbstractSimpleFolderFacade(IMailServiceFacade facade, IStorageFactory storageFactory, Class<MessageType> messageType, Folder folder) {
        super(facade, storageFactory);
        assert (messageType != null && messageType.isAssignableFrom(folder.contentType()));
        this.folder = folder;
        this.messageType = messageType;
    }

    @Override
    public Folder getMessageFolder(String id) throws IOException, CancelException {
        if (this.searchStorage(id) != null) {
            return this.folder;
        }
        return super.getMessageFolder(id);
    }

    @Override
    public List<IMailMessage> getMessages(Folder folder, String ... emprefs) throws IOException, CancelException {
        List<IMailMessage> result = super.getMessages(folder, emprefs);
        if (this.folder == folder) {
            result.addAll(this.readStorage(emprefs));
        }
        return result;
    }

    @Override
    public IMailMessage getMessage(Folder folder, String id) throws IOException, CancelException {
        IMailMessage result = null;
        if (this.folder == folder) {
            result = (IMailMessage)this.searchStorage(id);
        }
        if (result == null) {
            result = super.getMessage(folder, id);
        }
        return result;
    }

    @Override
    protected IStorage<MessageType> getStorage(String empRef) throws IOException, CancelException {
        return this.storageFactory.getStorage(this.folder.alias(), empRef, this.messageType);
    }

    @Override
    protected boolean isDeleteApplicable(Folder folder) {
        return this.folder == folder;
    }
}

