/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.WrappingFacade;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.service.DPSErrorEnum;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.storage.IStorable;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class AbstractFolderFacade<T extends IStorable>
extends WrappingFacade {
    private volatile boolean cancel;
    private volatile boolean cancelable;
    IStorageFactory storageFactory;

    public AbstractFolderFacade(IMailServiceFacade facade, IStorageFactory storageFactory) {
        super(facade);
        this.storageFactory = storageFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMessages(Folder folder, ArrayList<IDPSMessage> messages) throws IOException, CancelException {
        block10: {
            super.deleteMessages(folder, messages);
            String[] ids = new String[messages.size()];
            int iloop = 0;
            for (IMailMessage iMailMessage : messages) {
                String storeId = iMailMessage.getStoreId();
                ids[iloop++] = storeId;
            }
            this.cancelable = this.storageFactory.isInTransaction();
            try {
                if (!this.isDeleteApplicable(folder)) break block10;
                LinkedHashSet<String> toDelete = new LinkedHashSet<String>(Arrays.asList(ids));
                if (this.getCurrentUser() == null) {
                    throw new IllegalStateException("User not logged in");
                }
                for (String empRef : this.getCurrentUser().getEmpRef()) {
                    if (this.cancel) {
                        throw new CancelException();
                    }
                    IStorage<T> storage = this.getStorage(empRef);
                    Iterator it = toDelete.iterator();
                    while (it.hasNext()) {
                        String id = (String)it.next();
                        if (this.cancel) {
                            throw new CancelException();
                        }
                        if (!storage.contains(id)) continue;
                        if (this.cancel) {
                            throw new CancelException();
                        }
                        it.remove();
                        storage.delete(id);
                        if (!toDelete.isEmpty()) continue;
                        break block10;
                    }
                }
            }
            finally {
                this.cancelable = false;
                this.cancel = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMessages(Folder folder, String ... ids) throws IOException, CancelException {
        block9: {
            super.deleteMessages(folder, ids);
            this.cancelable = this.storageFactory.isInTransaction();
            try {
                if (!this.isDeleteApplicable(folder)) break block9;
                LinkedHashSet<String> toDelete = new LinkedHashSet<String>(Arrays.asList(ids));
                if (this.getCurrentUser() == null) {
                    throw new IllegalStateException("User not logged in");
                }
                for (String empRef : this.getCurrentUser().getEmpRef()) {
                    if (this.cancel) {
                        throw new CancelException();
                    }
                    IStorage<T> storage = this.getStorage(empRef);
                    Iterator it = toDelete.iterator();
                    while (it.hasNext()) {
                        String id = (String)it.next();
                        if (this.cancel) {
                            throw new CancelException();
                        }
                        if (!storage.contains(id)) continue;
                        if (this.cancel) {
                            throw new CancelException();
                        }
                        it.remove();
                        storage.delete(id);
                        if (!toDelete.isEmpty()) continue;
                        break block9;
                    }
                }
            }
            finally {
                this.cancelable = false;
                this.cancel = false;
            }
        }
    }

    @Override
    public void clearDownloads(String ... empRefs) throws IOException, CancelException {
        super.clearDownloads(empRefs);
        if (this.getCurrentUser() == null) {
            throw new IllegalStateException("User not logged in");
        }
        if (!Arrays.asList(this.getCurrentUser().getEmpRef()).containsAll(Arrays.asList(empRefs))) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_UNAUTHORISED_REFERENCE);
        }
        for (String empRef : empRefs) {
            IStorage<T> storage = this.getStorage(empRef);
            for (String id : storage.getIds()) {
                storage.delete(id);
            }
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.cancel = this.cancelable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T> readStorage(String ... empRefs) throws IOException, CancelException {
        this.cancelable = this.storageFactory.isInTransaction();
        try {
            if (this.getCurrentUser() == null) {
                throw new IllegalStateException("User not logged in");
            }
            ArrayList<T> result = new ArrayList<T>();
            List<String> validEmps = Arrays.asList(this.getCurrentUser().getEmpRef());
            for (String empRef : empRefs) {
                if (!validEmps.contains(empRef)) {
                    throw new DPSException(DPSErrorEnum.DPS_ERR_UNAUTHORISED_REFERENCE);
                }
                IStorage<T> storage = this.getStorage(empRef);
                if (this.cancel) {
                    throw new CancelException();
                }
                String[] ids = storage.getIds();
                result.ensureCapacity(result.size() + ids.length);
                for (String id : ids) {
                    if (this.cancel) {
                        throw new CancelException();
                    }
                    result.add(storage.load(id));
                }
            }
            ArrayList<T> arrayList = result;
            return arrayList;
        }
        finally {
            this.cancelable = false;
            this.cancel = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T searchStorage(String id) throws IOException, CancelException {
        if (this.getCurrentUser() == null) {
            throw new IllegalStateException("User not logged in");
        }
        this.cancelable = this.storageFactory.isInTransaction();
        try {
            for (String empRef : this.getCurrentUser().getEmpRef()) {
                IStorage<T> storage = this.getStorage(empRef);
                if (this.cancel) {
                    throw new CancelException();
                }
                if (!storage.contains(id)) continue;
                if (this.cancel) {
                    throw new CancelException();
                }
                T t = storage.load(id);
                return t;
            }
            String[] stringArray = null;
            return (T)stringArray;
        }
        finally {
            this.cancelable = false;
            this.cancel = false;
        }
    }

    protected abstract boolean isDeleteApplicable(Folder var1);

    protected abstract IStorage<T> getStorage(String var1) throws IOException, CancelException;
}

