/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.util;

import java.io.File;

public class Utils {
    public static String escape(String text) {
        text = text.trim();
        text = Utils.replaceAll(text, "&", "&amp;");
        text = Utils.replaceAll(text, "\"", "&quot;");
        text = Utils.replaceAll(text, "<", "&lt;");
        text = Utils.replaceAll(text, ">", "&gt;");
        text = Utils.replaceAll(text, "\n", " ");
        return text;
    }

    public static boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }

    public static File relativeFile(File rootDir, File file) {
        StringBuffer result = new StringBuffer(rootDir.getParentFile().getPath());
        result.append(File.separator);
        result.append(file.getPath());
        return new File(result.toString());
    }

    public static String relativeClasspathURL(File classPathEntry, String path) {
        String cp = classPathEntry.getParentFile().getPath();
        if (File.separatorChar != '/') {
            cp = cp.replace(File.separatorChar, '/');
        }
        return new StringBuffer(cp.length() + path.length() + 1).append(cp).append('/').append(path).toString();
    }

    private static String replaceAll(String text, String sample, String replacement) {
        String result = text;
        int endPos = text.indexOf(sample);
        if (endPos != -1) {
            StringBuffer product = new StringBuffer();
            int startPos = 0;
            do {
                product.append(text.substring(startPos, endPos));
                product.append(replacement);
            } while ((endPos = text.indexOf(sample, startPos = endPos + sample.length())) != -1);
            product.append(text.substring(startPos));
            result = product.toString();
        }
        return result;
    }
}

