/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;

public class LineAndColumnNumberReader
extends LineNumberReader {
    private int col;

    public LineAndColumnNumberReader(Reader reader) {
        super(reader);
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        switch (result) {
            case 10: {
                this.col = 0;
                break;
            }
            default: {
                ++this.col;
            }
        }
        return result;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int ln = super.getLineNumber();
        int result = super.read(cbuf, off, len);
        if (ln < super.getLineNumber()) {
            this.col = 0;
            for (int i = result - 1; i >= 0 && cbuf[off + i] != '\n'; --i) {
                ++this.col;
            }
        } else {
            this.col += result;
        }
        return result;
    }

    @Override
    public String readLine() throws IOException {
        String result = super.readLine();
        this.col = 0;
        return result;
    }

    public int getColumnNumber() {
        return this.col;
    }
}

