/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.util;

import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;

public class ExternalBrowserHelper {
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    public static void displayURL(String url) {
        block7: {
            if (url == null || "".equals(url)) {
                return;
            }
            boolean windows = ExternalBrowserHelper.isWindowsPlatform();
            String cmd = null;
            try {
                if (windows) {
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    Process process = Runtime.getRuntime().exec(cmd);
                    break block7;
                }
                cmd = "netscape -remote openURL(" + url + ")";
                Process p = Runtime.getRuntime().exec(cmd);
                try {
                    int exitCode = p.waitFor();
                    if (exitCode != 0) {
                        cmd = "netscape " + url;
                        p = Runtime.getRuntime().exec(cmd);
                    }
                }
                catch (InterruptedException x) {
                    LogAPI.logWarning((Throwable)x);
                }
            }
            catch (IOException x) {
                LogAPI.logSevere((Throwable)x);
            }
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }
}

