/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.ui;

import com.selima.framework.util.logging.LogAPI;
import com.selima.help.util.ExternalBrowserHelper;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.help.JHelpContentViewer;
import javax.help.plaf.basic.BasicContentViewerUI;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;

public class PatchedBasicContentViewerUI
extends BasicContentViewerUI {
    DocumentListenerRemover documentListenerRemover = new DocumentListenerRemover();

    public static ComponentUI createUI(JComponent x) {
        return new PatchedBasicContentViewerUI((JHelpContentViewer)x);
    }

    public PatchedBasicContentViewerUI(JHelpContentViewer viewer) {
        super(viewer);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.theViewer && "reload".equals(event.getPropertyName())) {
            JEditorPane html = this.getEditorPane();
            URL url = html.getPage();
            if (url != null) {
                try {
                    html.getDocument().putProperty("stream", null);
                    html.setPage(url);
                }
                catch (IOException e) {
                    LogAPI.logWarning((Throwable)e);
                }
            }
            return;
        }
        super.propertyChange(event);
    }

    private JEditorPane getEditorPane() {
        JScrollPane scrollPane = (JScrollPane)this.theViewer.getComponent(0);
        JEditorPane html = (JEditorPane)scrollPane.getViewport().getView();
        return html;
    }

    public void hyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            for (Element element = evt.getSourceElement(); element != null; element = element.getParentElement()) {
                if (!"yellow-note".equals(element.getAttributes().getAttribute(HTML.Attribute.CLASS))) continue;
                try {
                    ExternalBrowserHelper.displayURL(evt.getURL().toURI().toString());
                }
                catch (URISyntaxException e) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return;
            }
        }
        super.hyperlinkUpdate(evt);
    }

    class DocumentListenerRemover
    implements AncestorListener {
        List<DocumentListener> listeners = new LinkedList<DocumentListener>();

        DocumentListenerRemover() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            if (!this.listeners.isEmpty()) {
                AbstractDocument document = (AbstractDocument)PatchedBasicContentViewerUI.this.getEditorPane().getDocument();
                this.listeners.removeAll(Arrays.asList(document.getDocumentListeners()));
                for (DocumentListener listener : this.listeners) {
                    PatchedBasicContentViewerUI.this.getEditorPane().getDocument().addDocumentListener(listener);
                }
                this.listeners.clear();
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            AbstractDocument document = (AbstractDocument)PatchedBasicContentViewerUI.this.getEditorPane().getDocument();
            this.listeners.addAll(Arrays.asList(document.getDocumentListeners()));
            for (DocumentListener listener : this.listeners) {
                document.removeDocumentListener(listener);
            }
        }
    }
}

