/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring.toc;

import com.selima.help.authoring.AuthoringException;
import com.selima.help.authoring.ContentLocator;
import com.selima.help.authoring.HelpSetInfo;
import com.selima.help.authoring.toc.ITocChapterItem;
import com.selima.help.authoring.toc.ITocInfo;
import com.selima.help.authoring.toc.ITocInfoParser;
import com.selima.help.authoring.toc.ITocItem;
import com.selima.help.authoring.toc.ITocPageItem;
import com.selima.help.authoring.toc.TocChapterItemImpl;
import com.selima.help.authoring.toc.TocInfoParser;
import com.selima.help.util.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.xml.sax.SAXException;

public class TocGenerator {
    ContentLocator contentLocator;
    ITocInfoParser tocParser;
    PrintWriter printer;
    Indent indent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void generateToc(TocData data) throws AuthoringException {
        try {
            this.contentLocator = new ContentLocator(data.htmlRoot);
            this.tocParser = new TocInfoParser(this.contentLocator);
            this.indent = new Indent();
            HelpSetInfo helpSet = new HelpSetInfo(data.helpSetFile);
            this.printer = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(helpSet.getTocFile())), "UTF-8"));
            this.writeProlog(data);
            this.traverseToc(new TocChapterItemImpl(data.rootTocFile));
            this.writeEpilog();
            this.printer.flush();
        }
        catch (SAXException e) {
            throw new AuthoringException(e);
        }
        catch (IOException e) {
            throw new AuthoringException(e);
        }
        finally {
            this.contentLocator = null;
            this.tocParser = null;
            this.indent = null;
            if (this.printer != null) {
                try {
                    this.printer.close();
                }
                finally {
                    this.printer = null;
                }
            }
        }
    }

    private void traverseToc(ITocChapterItem chapter) throws IOException, SAXException {
        this.indent.inc();
        ITocInfo tocInfo = this.tocParser.parse(chapter.getTargetFile());
        this.writeDirProlog(tocInfo.getItem());
        for (ITocItem item : tocInfo.getContent()) {
            if (item instanceof ITocPageItem) {
                ITocPageItem pageItem = (ITocPageItem)item;
                this.writeEntry(pageItem);
                continue;
            }
            if (!(item instanceof ITocChapterItem)) continue;
            ITocChapterItem chapterItem = (ITocChapterItem)item;
            this.traverseToc(chapterItem);
        }
        this.writeDirEpilog();
        this.indent.dec();
    }

    private void writeProlog(TocData data) throws IOException {
        this.printer.println("<!DOCTYPE toc PUBLIC '-//Sun Microsystems Inc.//DTD JavaHelp TOC Version 1.0//EN' 'http://java.sun.com/products/javahelp/toc_1_0.dtd'>");
        this.printer.print("<toc version=\"2.0\" xml:lang=\"en\" ");
        ContentLocator cl = new ContentLocator(data.htmlRoot);
        if (data.categoryClosedImage != null) {
            this.printer.print("categoryclosedimage=\"" + cl.getHelpId(data.categoryClosedImage) + "\" ");
        }
        if (data.categoryOpenImage != null) {
            this.printer.print("categoryopenimage=\"" + cl.getHelpId(data.categoryOpenImage) + "\" ");
        }
        if (data.topicImage != null) {
            this.printer.print("topicimage=\"" + cl.getHelpId(data.topicImage) + "\" ");
        }
        this.printer.println(">");
    }

    private void writeDirProlog(ITocPageItem item) {
        this.printer.print(this.indent);
        this.printer.print("<tocitem expand=\"");
        this.printer.print(this.indent.getDepth() < 1);
        this.printer.print("\"");
        if (item.getName() != null) {
            this.printer.print(" text=\"");
            this.printer.print(Utils.escape(item.getName()));
            this.printer.print("\"");
        }
        if (item.getHelpid() != null) {
            this.printer.print(" target=\"");
            this.printer.print(item.getHelpid());
            this.printer.print("\"");
        }
        if (item.getImage() != null) {
            this.printer.print(" image=\"");
            this.printer.print(item.getImage());
            this.printer.print("\"");
        }
        this.printer.println(">");
    }

    private void writeDirEpilog() {
        this.printer.print(this.indent);
        this.printer.println("</tocitem>");
    }

    private void writeEntry(ITocPageItem item) {
        this.printer.print(this.indent);
        this.printer.print("<tocitem text=\"" + Utils.escape(item.getName()) + "\" target=\"" + item.getHelpid() + "\"");
        if (item.getImage() != null) {
            this.printer.println(" image=\"" + item.getImage() + "\"/>");
        } else {
            this.printer.println(" />");
        }
    }

    private void writeEpilog() {
        this.printer.println("</toc>");
    }

    public static void main(String[] args) {
        try {
            TocData data = new TocData();
            data.helpSetFile = new File("content\\payroll.hs");
            data.htmlRoot = new File("content\\doc");
            data.rootTocFile = new File("content\\doc\\tocinfo.xml");
            new TocGenerator().generateToc(data);
        }
        catch (AuthoringException e) {
            e.printStackTrace();
        }
    }

    private static class Indent {
        private static final String STEP = "  ";
        int depth;
        private StringBuffer indent = new StringBuffer();

        private Indent() {
        }

        void inc() {
            ++this.depth;
            this.indent.append(STEP);
        }

        void dec() {
            --this.depth;
            this.indent.setLength(this.indent.length() - STEP.length());
        }

        int getDepth() {
            return this.depth;
        }

        public String toString() {
            return this.indent.toString();
        }
    }

    public static class TocData {
        public File helpSetFile;
        public File htmlRoot;
        public File rootTocFile;
        public File categoryOpenImage;
        public File categoryClosedImage;
        public File topicImage;
    }
}

