/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring.toc;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class TocFileContentHandler
extends DefaultHandler {
    TocInfoHandler handler = new TocInfoHandler();

    TocFileContentHandler() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.handler.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.handler.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.handler.endElement(uri, localName, qName);
    }

    TocPageStruct getItem() {
        return this.handler.getItemStruct();
    }

    List<TocItemStruct> getContent() {
        return this.handler.getContent();
    }

    static class TocInfoHandler
    extends TocPageStructHandler {
        StructHandler activeHandler = null;
        List<TocItemStruct> list = new LinkedList<TocItemStruct>();

        TocInfoHandler() {
        }

        public List<TocItemStruct> getContent() {
            return this.list;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("entry".equals(qName)) {
                this.activeHandler = new TocPageStructHandler();
            } else if ("outline".equals(qName)) {
                this.activeHandler = new TocChapterStructHandler();
            }
            if (this.activeHandler != null) {
                this.activeHandler.startElement(uri, localName, qName, attributes);
            } else {
                super.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.activeHandler != null) {
                this.activeHandler.endElement(uri, localName, qName);
                if ("entry".equals(qName) || "outline".equals(qName)) {
                    this.list.add((TocItemStruct)this.activeHandler.getItemStruct());
                    this.activeHandler = null;
                }
            } else {
                super.endElement(uri, localName, qName);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.activeHandler != null) {
                this.activeHandler.characters(ch, start, length);
            } else {
                super.characters(ch, start, length);
            }
        }
    }

    static class TocChapterStructHandler
    extends StructHandler<TocChapterStruct> {
        TocChapterStructHandler() {
        }

        @Override
        TocChapterStruct getItemStruct() {
            TocChapterStruct result = new TocChapterStruct();
            result.outline = (String)this.map.get("outline");
            return result;
        }
    }

    static class TocPageStructHandler
    extends StructHandler<TocPageStruct> {
        TocPageStructHandler() {
        }

        @Override
        TocPageStruct getItemStruct() {
            TocPageStruct result = new TocPageStruct();
            result.name = (String)this.map.get("name");
            result.file = (String)this.map.get("file");
            result.image = (String)this.map.get("image");
            return result;
        }
    }

    static abstract class StructHandler<T extends TocItemStruct>
    extends AbstractHandler {
        StructHandler() {
        }

        abstract T getItemStruct();
    }

    static abstract class AbstractHandler
    extends DefaultHandler {
        protected Map<String, String> map = new HashMap<String, String>();
        StringBuilder characters;

        AbstractHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.characters = new StringBuilder();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.map.put(qName, this.characters.toString());
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.characters.append(ch, start, length);
        }
    }

    static class TocChapterStruct
    implements TocItemStruct {
        String outline;

        TocChapterStruct() {
        }
    }

    static class TocPageStruct
    implements TocItemStruct {
        String name;
        String file;
        String image;

        TocPageStruct() {
        }
    }

    static interface TocItemStruct {
    }
}

