/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring.map;

import com.selima.help.authoring.AuthoringException;
import com.selima.help.authoring.ContentLocator;
import com.selima.help.authoring.HelpSetInfo;
import com.selima.help.util.HTMLParserHelper;
import com.selima.help.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.AttributeSet;

public class MapGenerator {
    private FilenameFilter filenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.startsWith(".") && !"tocinfo.xml".equals(name);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateMap(File helpSetFile, File htmlRoot) throws AuthoringException {
        HelpSetInfo info = new HelpSetInfo(helpSetFile);
        try (PrintWriter printer = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(info.getMapFile())), "UTF-8"));){
            this.writeProlog(printer);
            this.traverseDir(htmlRoot, new TraverseParams(printer, new ContentLocator(htmlRoot), new AnchorDetector()));
            this.writeEpilog(printer);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            throw new AuthoringException(e);
        }
        catch (IOException e) {
            throw new AuthoringException(e);
        }
    }

    private void traverseDir(File dir, TraverseParams traverseParams) throws IOException {
        File[] files = dir.listFiles(this.filenameFilter);
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.traverseDir(files[i], traverseParams);
                continue;
            }
            File file = files[i];
            PrintWriter printer = traverseParams.printer;
            ContentLocator locator = traverseParams.locator;
            this.writeEntry(printer, locator.getHelpId(file), locator.getURL(file));
            for (String anchor : traverseParams.detector.analyze(files[i])) {
                this.writeEntry(printer, locator.getHelpId(file, anchor), locator.getURL(file, anchor));
            }
        }
    }

    private void writeProlog(PrintWriter printer) {
        printer.println("<!DOCTYPE map PUBLIC '-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN' 'http://java.sun.com/products/javahelp/map_1_0.dtd'>");
        printer.println("<map version=\"2.0\" xml:lang=\"en\">");
    }

    private void writeEntry(PrintWriter printer, String helpid, String url) {
        printer.print("    <mapID target=\"");
        printer.print(Utils.escape(helpid));
        printer.print("\" url=\"");
        printer.print(Utils.escape(url));
        printer.println("\"/>");
    }

    private void writeEpilog(PrintWriter printer) {
        printer.println("</map>");
    }

    public static void main(String[] args) {
        try {
            new MapGenerator().generateMap(new File("content/payroll.hs"), new File("content/doc"));
        }
        catch (AuthoringException e) {
            e.printStackTrace();
        }
    }

    static class AnchorDetector
    extends HTMLParserHelper {
        List<String> anchors = new LinkedList<String>();

        AnchorDetector() {
        }

        List<String> analyze(File file) throws IOException {
            this.anchors.clear();
            if (file.getName().endsWith(".html")) {
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                    super.parse(new CallBack(), stream);
                }
            }
            return this.anchors;
        }

        class CallBack
        implements HTMLParserHelper.HTMLParserTemplatePlugin {
            CallBack() {
            }

            @Override
            public void startElement(String name, AttributeSet attrs, boolean notPairHTMLTag) throws IOException {
                if ("a".equals(name) && attrs.isDefined("name")) {
                    AnchorDetector.this.anchors.add((String)attrs.getAttribute("name"));
                }
            }

            @Override
            public void characters(char[] data) {
            }

            @Override
            public void endElement(String name) throws IOException {
            }
        }
    }

    static class TraverseParams {
        PrintWriter printer;
        ContentLocator locator;
        AnchorDetector detector;

        TraverseParams(PrintWriter printer, ContentLocator locator, AnchorDetector detector) {
            this.printer = printer;
            this.locator = locator;
            this.detector = detector;
        }
    }
}

