/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring.index;

import com.selima.help.authoring.index.DistanceMatrix;
import com.selima.help.authoring.index.IndexEntry;
import com.selima.help.authoring.index.IndexingAlgorithm;
import com.selima.help.authoring.index.SeparateLogger;
import com.selima.help.authoring.index.TermGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;

class TermGroupList {
    List<TermGroup> groups = new ArrayList<TermGroup>();
    DifferenceStruct minimumDifference;
    private DistanceMatrix matrix;
    int entryCount = -1;

    TermGroupList() {
    }

    void add(TermGroup group) {
        boolean found = false;
        for (TermGroup g : this.groups) {
            if (!g.contains(group)) continue;
            found = true;
            g.merge(group);
            break;
        }
        if (!found) {
            this.groups.add(group);
        }
    }

    void removeLightestGroup() {
        Collections.sort(this.groups, new Comparator<TermGroup>(){

            @Override
            public int compare(TermGroup g1, TermGroup g2) {
                return g1.weight() - g2.weight();
            }
        });
        TermGroup tg = this.groups.remove(0);
        SeparateLogger.getInstance().log(Level.FINE, "stripping {0}", new Object[]{tg});
        this.entryCount = -1;
    }

    void collapseMostSimilarGroups() {
        if (this.minimumDifference == null) {
            this.minimumDifference = this.searchForMinimum();
        }
        SeparateLogger.getInstance().log(Level.FINE, "merging ({0},{1}) on difference {2}", new Object[]{this.minimumDifference.tg1, this.minimumDifference.tg2, this.minimumDifference.value});
        this.minimumDifference.tg1.merge(this.minimumDifference.tg2);
        this.groups.remove(this.minimumDifference.index2);
        this.matrix.clearFirstRemoveSecond(this.minimumDifference.index1, this.minimumDifference.index2);
        this.minimumDifference = null;
        this.entryCount = -1;
    }

    void filterNonFrequentWords(int minCount, int maxCount) {
        Iterator<TermGroup> it = this.groups.iterator();
        while (it.hasNext()) {
            TermGroup tg = it.next();
            if (tg.occurenceCount() >= minCount && tg.occurenceCount() <= maxCount) continue;
            it.remove();
        }
        this.entryCount = -1;
    }

    Double minimumDifference() {
        if (this.minimumDifference == null) {
            this.minimumDifference = this.searchForMinimum();
        }
        return this.minimumDifference.value;
    }

    private DifferenceStruct searchForMinimum() {
        if (this.matrix == null) {
            this.matrix = new DistanceMatrix(this.groups.size());
        }
        DifferenceStruct result = new DifferenceStruct();
        int i = 0;
        for (TermGroup tg1 : this.groups) {
            int j = 0;
            for (TermGroup tg2 : this.groups) {
                Double value;
                if (i <= j) break;
                if (this.matrix.has(i, j)) {
                    value = this.matrix.get(i, j);
                } else {
                    value = tg1.difference(tg2);
                    if (value >= IndexingAlgorithm.DIFFERENCE_LIMIT) {
                        value = IndexingAlgorithm.DIFFERENCE_LIMIT;
                    }
                    this.matrix.put(i, j, value);
                }
                if (value < result.value) {
                    result.value = value;
                    result.index1 = i;
                    result.index2 = j;
                    result.tg1 = tg1;
                    result.tg2 = tg2;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    int entryCount() {
        if (this.entryCount == -1) {
            this.entryCount = 0;
            for (TermGroup tg : this.groups) {
                this.entryCount += tg.getEntryCount();
            }
        }
        return this.entryCount;
    }

    SortedSet<IndexEntry> getEntries() {
        TreeSet<IndexEntry> result = new TreeSet<IndexEntry>();
        for (TermGroup tg : this.groups) {
            result.addAll(tg.getEntries());
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (TermGroup tg : this.groups) {
            result.append(tg).append('\n');
        }
        return result.toString();
    }

    int occurenceCount() {
        int result = 0;
        for (TermGroup tg : this.groups) {
            result += tg.occurenceCount();
        }
        return result;
    }

    String statistic() {
        return this.groups.size() + " groups with " + this.entryCount() + " proposed entries from " + this.occurenceCount() + " occurences.";
    }

    static class DifferenceStruct {
        static Double MAX_VALUE = Double.MAX_VALUE;
        Double value = MAX_VALUE;
        int index1 = -1;
        int index2 = -1;
        TermGroup tg1;
        TermGroup tg2;

        DifferenceStruct() {
        }
    }
}

