/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring.index;

import com.selima.help.authoring.index.IndexEntry;
import com.selima.help.authoring.index.SeparateLogger;
import com.selima.help.authoring.index.Term;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

class TermGroup {
    List<Pair> list = new LinkedList<Pair>();
    int documentCount = -1;
    Set<Term> terms;

    TermGroup(String term, String helpId) {
        this.list.add(new Pair(new Term(term), helpId));
    }

    double difference(TermGroup other) {
        double result = 0.0;
        for (Term t1 : this.getTerms()) {
            for (Term t2 : other.getTerms()) {
                result += t1.difference(t2);
            }
        }
        result = result / (double)this.termCount() * (double)other.termCount();
        if (SeparateLogger.getInstance().isLoggable(Level.FINER)) {
            SeparateLogger.getInstance().log(Level.FINER, "difference({0},{1})={2}", new Object[]{this, other, String.valueOf(result)});
        }
        return result;
    }

    boolean contains(TermGroup otherGroup) {
        return this.list.containsAll(otherGroup.list);
    }

    void merge(TermGroup otherGroup) {
        this.documentCount = -1;
        this.terms = null;
        this.list.addAll(otherGroup.list);
    }

    Set<IndexEntry> getEntries() {
        HashSet<IndexEntry> result = new HashSet<IndexEntry>();
        HashSet<String> docs = new HashSet<String>();
        for (Pair pair : this.list) {
            if (docs.contains(pair.helpId)) continue;
            docs.add(pair.helpId);
            result.add(new IndexEntry(pair.term.text, pair.helpId));
        }
        return result;
    }

    int getEntryCount() {
        return this.documentCount();
    }

    private int documentCount() {
        if (this.documentCount == -1) {
            HashSet<String> helpIdSet = new HashSet<String>(this.list.size());
            for (Pair pair : this.list) {
                helpIdSet.add(pair.helpId);
            }
            this.documentCount = helpIdSet.size();
        }
        return this.documentCount;
    }

    int occurenceCount() {
        return this.list.size();
    }

    private int termCount() {
        return this.getTerms().size();
    }

    private Set<Term> getTerms() {
        if (this.terms == null) {
            this.terms = new HashSet<Term>(this.list.size());
            for (Pair pair : this.list) {
                this.terms.add(pair.term);
            }
        }
        return this.terms;
    }

    int weight() {
        int wf = this.occurenceCount();
        int df = this.documentCount();
        return (wf - df) * (wf - df) * (wf - df) - df * df;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('[');
        for (Term term : this.getTerms()) {
            result.append(term).append(',');
        }
        result.setLength(result.length() - 1);
        result.append("] total ").append(this.occurenceCount()).append(" occurences in ").append(this.documentCount()).append(" docs");
        return result.toString();
    }

    static class Pair {
        Term term;
        String helpId;

        Pair(Term term, String helpId) {
            this.term = term;
            this.helpId = helpId;
        }

        public boolean equals(Object other) {
            return this.term.equalsIgnoreCase(((Pair)other).term);
        }
    }
}

