/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring.index;

import com.selima.framework.util.logging.LogAPI;
import com.selima.help.authoring.AuthoringException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

class Phrases {
    private static final Set<String> PHRASE_TAG_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("SPAN", "I", "B", "CODE", "H1", "H2", "H3")));
    private static final int PHRASE_LENGTH = 30;
    private List<String> phraseList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Phrases(String path) throws AuthoringException {
        try {
            Parser parser = new Parser(path);
            try {
                LinkedList<Node> nodeQueue = new LinkedList<Node>();
                NodeIterator it = parser.elements();
                while (it.hasMoreNodes()) {
                    nodeQueue.add(it.nextNode());
                }
                this.phraseList = new LinkedList<String>();
                this.extractPhrases(this.phraseList, nodeQueue, new DefaultPhraseFactory());
            }
            finally {
                try {
                    parser.getLexer().getPage().getSource().destroy();
                }
                catch (IOException e) {
                    LogAPI.logSevere((Throwable)e);
                }
            }
        }
        catch (ParserException e) {
            throw new AuthoringException(e);
        }
    }

    public List getContent() {
        return this.phraseList;
    }

    private void extractPhrases(List<String> phraseList, List<Node> nodeQueue, PhraseFactory factory) {
        ArrayList<PhraseBuilder> builderList = new ArrayList<PhraseBuilder>();
        while (!nodeQueue.isEmpty()) {
            PhraseBuilder builder;
            Node node = nodeQueue.remove(0);
            if (node instanceof CompositeTag) {
                CompositeTag ct = (CompositeTag)node;
                Node[] nodes = ct.getChildrenAsNodeArray();
                nodeQueue.addAll(0, Arrays.asList(nodes));
            }
            if ((builder = factory.createBuilder(node)) != null) {
                builderList.add(builder);
            }
            for (int i = builderList.size() - 1; i >= 0; --i) {
                PhraseBuilder pb = (PhraseBuilder)builderList.get(i);
                if (pb.grow(node)) continue;
                builderList.remove(i);
                String phrase = pb.getPhrase();
                if (phrase == null) continue;
                if (phrase.length() > 30) {
                    int pos = 30;
                    while (pos < phrase.length() && !Character.isWhitespace(phrase.charAt(pos++))) {
                    }
                    phrase = phrase.substring(0, pos);
                }
                if ((phrase = phrase.trim()).length() <= 0) continue;
                phraseList.add(this.unEscape(phrase));
            }
        }
    }

    private String unEscape(String text) {
        return text.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&");
    }

    private static class TagBuilder
    implements PhraseBuilder {
        private StringBuffer buffer;
        private Tag startTag;

        TagBuilder(Tag tag) {
            this.startTag = tag;
            this.buffer = new StringBuffer();
        }

        @Override
        public boolean grow(Node node) {
            boolean result = true;
            if (node instanceof TextNode) {
                this.buffer.append(((TextNode)node).getText());
            } else if (node instanceof Tag) {
                Tag tag = (Tag)node;
                if (tag.isEndTag()) {
                    result = !this.startTag.getTagName().equals(tag.getTagName());
                } else {
                    String[] tagNames = this.startTag.getEnders();
                    for (int i = 0; i < tagNames.length; ++i) {
                        if (!tag.getTagName().equals(tagNames[i])) continue;
                        result = false;
                        break;
                    }
                }
            }
            return result;
        }

        @Override
        public String getPhrase() {
            return this.buffer.toString().replaceAll("&nbsp;", "");
        }
    }

    private static class CompositeBuilder
    implements PhraseBuilder {
        private String text;
        private static final NodeFilter TEXT_NODE_FILTER = new NodeClassFilter(TextNode.class);

        private CompositeBuilder() {
        }

        @Override
        public boolean grow(Node node) {
            CompositeTag tag = (CompositeTag)node;
            NodeList list = new NodeList();
            tag.collectInto(list, TEXT_NODE_FILTER);
            Node[] nodes = list.toNodeArray();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < nodes.length; ++i) {
                buffer.append(((TextNode)nodes[i]).getText());
            }
            this.text = buffer.toString();
            return false;
        }

        @Override
        public String getPhrase() {
            return this.text;
        }
    }

    private static interface PhraseBuilder {
        public boolean grow(Node var1);

        public String getPhrase();
    }

    private static class DefaultPhraseFactory
    implements PhraseFactory {
        private DefaultPhraseFactory() {
        }

        @Override
        public PhraseBuilder createBuilder(Node node) {
            Tag tag;
            PhraseBuilder result = null;
            if (node instanceof Tag && !(tag = (Tag)node).isEndTag() && !tag.isEmptyXmlTag() && PHRASE_TAG_SET.contains(tag.getTagName())) {
                result = node instanceof CompositeTag ? new CompositeBuilder() : new TagBuilder((Tag)node);
            }
            return result;
        }
    }

    private static interface PhraseFactory {
        public PhraseBuilder createBuilder(Node var1);
    }
}

