/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring.index;

import com.selima.framework.util.logging.LogAPI;
import com.selima.help.authoring.AuthoringException;
import com.selima.help.authoring.ContentLocator;
import com.selima.help.authoring.HelpSetInfo;
import com.selima.help.authoring.index.IndexEntry;
import com.selima.help.authoring.index.IndexFormatter;
import com.selima.help.authoring.index.IndexingAlgorithm;
import com.selima.help.authoring.index.MapInfo;
import com.selima.help.authoring.index.Phrases;
import com.selima.help.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IndexGenerator {
    public static final String INDEXED_TYPES = "html,htm";

    public void generateIndex(File helpSetFile, File htmlRoot, int indexsize) throws AuthoringException {
        HelpSetInfo helpSetInfo = new HelpSetInfo(helpSetFile);
        MapInfo mapInfo = new MapInfo(helpSetInfo.getMapFile(), INDEXED_TYPES);
        IndexingAlgorithm indexer = new IndexingAlgorithm();
        ContentLocator locator = null;
        try {
            locator = new ContentLocator(htmlRoot);
        }
        catch (IOException e) {
            throw new AuthoringException(e);
        }
        String[] helpids = mapInfo.helpIds();
        for (int i = 0; i < helpids.length; ++i) {
            String helpid = helpids[i];
            if (locator.isAnchorHelpId(helpid)) continue;
            String path = mapInfo.getFilePath(helpid);
            Phrases phrases = new Phrases(Utils.relativeClasspathURL(htmlRoot, path));
            for (Object phrase : phrases.getContent()) {
                indexer.add((String)phrase, helpid);
            }
        }
        LinkedList<IndexEntry> entries = new LinkedList<IndexEntry>(indexer.process(indexsize));
        new IndexFormatter().writeFile(helpSetInfo.getIndexFile(), entries);
    }

    public static void main(String[] args) throws AuthoringException {
        Logger.getLogger("").setLevel(Level.FINER);
        long startTime = System.currentTimeMillis();
        new IndexGenerator().generateIndex(new File("content\\payroll.hs"), new File("content\\doc"), 500);
        LogAPI.logInfo((String)("Index generated in " + (System.currentTimeMillis() - startTime) + " ms"));
    }
}

