/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring.index;

import com.selima.help.authoring.AuthoringException;
import com.selima.help.authoring.index.IndexEntry;
import com.selima.help.util.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;

class IndexFormatter {
    IndexFormatter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFile(File indexFile, List entries) throws AuthoringException {
        try (PrintWriter printer = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(indexFile)), "UTF-8"));){
            printer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printer.println("<!DOCTYPE index PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp Index Version 1.0//EN\" \"http://java.sun.com/products/javahelp/index_1_0.dtd\">");
            printer.println("<index version=\"2.0\">");
            for (IndexEntry entry : entries) {
                printer.print("<indexitem text=\"");
                printer.print(Utils.escape(entry.getPhrase()));
                printer.print("\" target=\"");
                printer.print(Utils.escape(entry.getHelpid()));
                printer.println("\"/>");
            }
            printer.println("</index>");
            printer.flush();
            if (printer.checkError()) {
                throw new AuthoringException("PrinteWriter write error");
            }
        }
        catch (FileNotFoundException e) {
            throw new AuthoringException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

