/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring;

import com.selima.help.authoring.AuthoringException;
import com.selima.help.authoring.index.JavaHelpEntityResolver;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class HelpSetInfo {
    private File mapFile;
    private File indexFile;
    private File tocFile;

    public HelpSetInfo(File helpSetFile) throws AuthoringException {
        try {
            Document doc = this.createDocument(helpSetFile);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String file = (String)xPath.evaluate("maps/mapref/@location", doc.getDocumentElement(), XPathConstants.STRING);
            if (file == null) {
                throw new AuthoringException("Map file not found");
            }
            this.mapFile = HelpSetInfo.relativeFile(helpSetFile, new File(file));
            file = (String)xPath.evaluate("view[type='javax.help.IndexView']/data", doc.getDocumentElement(), XPathConstants.STRING);
            if (file == null) {
                throw new AuthoringException("Index file not found");
            }
            this.indexFile = HelpSetInfo.relativeFile(helpSetFile, new File(file));
            file = (String)xPath.evaluate("view[type='javax.help.TOCView']/data", doc.getDocumentElement(), XPathConstants.STRING);
            if (file == null) {
                throw new AuthoringException("TOC file not found");
            }
            this.tocFile = HelpSetInfo.relativeFile(helpSetFile, new File(file));
        }
        catch (ParserConfigurationException e) {
            throw new AuthoringException(e);
        }
        catch (SAXException e) {
            throw new AuthoringException(e);
        }
        catch (IOException e) {
            throw new AuthoringException(e);
        }
        catch (XPathExpressionException e) {
            throw new AuthoringException(e);
        }
    }

    public File getMapFile() {
        return this.mapFile;
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    public File getTocFile() {
        return this.tocFile;
    }

    public static File relativeFile(File currentFile, File targetFile) throws IOException {
        File currentDir = currentFile.getParentFile();
        StringBuffer result = new StringBuffer(currentDir.getPath());
        result.append(File.separatorChar).append(targetFile.getPath());
        return new File(result.toString()).getCanonicalFile();
    }

    private Document createDocument(File helpSetFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(JavaHelpEntityResolver.getInstance());
        return builder.parse(helpSetFile);
    }
}

