/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.util.SimpleThreadPoolTask;

public class SimpleThreadPool {
    private static final Logger logger = Logger.getLogger(SimpleThreadPool.class.getName());
    private final LinkedList taskList = new LinkedList();
    private final Set runningSet = new HashSet();
    private final int minThreads;
    private final int maxThreads;
    private final String name;
    private final int idleAliveMillis;
    private final Object taskMonitor = new Object();
    private final ThreadGroup threadGroup;
    private int numThreads = 0;
    private int numIdleThreads = 0;
    private int threadNumber = 0;

    public SimpleThreadPool(String name, int minShrinkToThreads, int maxThreads, int idleAliveMillis) {
        this.minThreads = minShrinkToThreads;
        this.maxThreads = maxThreads;
        this.idleAliveMillis = idleAliveMillis;
        this.name = name;
        this.threadGroup = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(SimpleThreadPoolTask task) {
        Object monitor;
        if (task == null) {
            throw new IllegalArgumentException("null task");
        }
        Object object = monitor = this.taskMonitor;
        synchronized (object) {
            if (this.numIdleThreads == 0) {
                this.addThreadImpl();
            }
            this.taskList.add(task);
            monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(SimpleThreadPoolTask task) {
        Object object = this.taskMonitor;
        synchronized (object) {
            this.taskList.remove(task);
        }
        task.cancel();
    }

    private void addThreadImpl() {
        if (this.numThreads < this.maxThreads) {
            Thread t = new Thread(this.threadGroup, new ThreadRunnable(), String.valueOf(this.name) + this.threadNumber++);
            t.setDaemon(true);
            t.start();
            ++this.numThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Object object = this.taskMonitor;
        synchronized (object) {
            this.taskList.clear();
            Iterator i = this.runningSet.iterator();
            while (i.hasNext()) {
                ((SimpleThreadPoolTask)i.next()).cancel();
            }
        }
    }

    static /* synthetic */ Object access$0(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.taskMonitor;
    }

    static /* synthetic */ LinkedList access$1(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.taskList;
    }

    static /* synthetic */ Set access$2(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.runningSet;
    }

    static /* synthetic */ int access$3(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.idleAliveMillis;
    }

    static /* synthetic */ int access$4(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.numIdleThreads;
    }

    static /* synthetic */ void access$5(SimpleThreadPool simpleThreadPool, int n) {
        simpleThreadPool.numIdleThreads = n;
    }

    static /* synthetic */ int access$6(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.numThreads;
    }

    static /* synthetic */ int access$7(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.minThreads;
    }

    static /* synthetic */ void access$8(SimpleThreadPool simpleThreadPool, int n) {
        simpleThreadPool.numThreads = n;
    }

    static /* synthetic */ Logger access$9() {
        return logger;
    }

    static /* synthetic */ String access$10(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.name;
    }

    private class ThreadRunnable
    implements Runnable {
        private ThreadRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            monitor = SimpleThreadPool.access$0(SimpleThreadPool.this);
            tl = SimpleThreadPool.access$1(SimpleThreadPool.this);
            rs = SimpleThreadPool.access$2(SimpleThreadPool.this);
            iam = SimpleThreadPool.access$3(SimpleThreadPool.this);
            task = null;
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        var6_6 = monitor;
                        synchronized (var6_6) {
                            if (task != null) {
                                rs.remove(task);
                            }
                            v0 = SimpleThreadPool.this;
                            SimpleThreadPool.access$5(v0, SimpleThreadPool.access$4(v0) + 1);
                            try {
                                waitBase = System.currentTimeMillis();
                                while (tl.isEmpty()) {
                                    maxWait = (long)iam - (System.currentTimeMillis() - waitBase);
                                    if (maxWait <= 0L) {
                                        if (SimpleThreadPool.access$6(SimpleThreadPool.this) > SimpleThreadPool.access$7(SimpleThreadPool.this)) {
                                            v1 = SimpleThreadPool.this;
                                            SimpleThreadPool.access$8(v1, SimpleThreadPool.access$6(v1) - 1);
                                            return;
                                        }
                                        waitBase = System.currentTimeMillis();
                                        continue;
                                    }
                                    monitor.wait(maxWait);
                                }
                            }
                            finally {
                                v2 = SimpleThreadPool.this;
                                SimpleThreadPool.access$5(v2, SimpleThreadPool.access$4(v2) - 1);
                            }
                            task = (SimpleThreadPoolTask)SimpleThreadPool.access$1(SimpleThreadPool.this).removeFirst();
                            rs.add(task);
                        }
                        currentThread = Thread.currentThread();
                        baseName = currentThread.getName();
                        try {
                            try {
                                currentThread.setName(String.valueOf(baseName) + ":" + task.toString());
                            }
                            catch (Throwable thrown) {
                                SimpleThreadPool.access$9().log(Level.WARNING, "run(): Unable to set task name.", thrown);
                            }
                            try {
                                task.run();
                            }
                            catch (Throwable thrown) {
                                SimpleThreadPool.access$9().log(Level.SEVERE, "run(): Error in task: " + task + ".", thrown);
                            }
                        }
                        finally {
                            currentThread.setName(baseName);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable thrown) {
                    SimpleThreadPool.access$9().log(Level.SEVERE, "run(): Error in thread pool: " + SimpleThreadPool.access$10(SimpleThreadPool.this) + ".", thrown);
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }
    }
}

