/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Collection;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.TextImpl;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.RenderState;

final class RWord
extends BaseBoundableRenderable {
    final String shownWord;
    public final FontMetrics fontMetrics;
    public final int descent;
    public final int ascentPlusLeading;

    public RWord(ModelNode me, String word, RenderableContainer container, FontMetrics fontMetrics, int descent, int ascentPlusLeading, int height, int textTransform) {
        super(container, me);
        String renderedWord;
        this.shownWord = renderedWord = textTransform == 0 ? word : this.transformText(word, textTransform);
        this.fontMetrics = fontMetrics;
        this.descent = descent;
        this.ascentPlusLeading = ascentPlusLeading;
        this.height = height;
        this.width = fontMetrics.stringWidth(renderedWord);
    }

    private String transformText(String word, int textTransform) {
        String string;
        switch (textTransform) {
            case 1: {
                string = String.valueOf(Character.toTitleCase(word.charAt(0))) + word.substring(1).toLowerCase();
                break;
            }
            case 4: {
                string = word.toLowerCase();
                break;
            }
            case 2: {
                string = word.toUpperCase();
                break;
            }
            default: {
                string = word;
            }
        }
        return string;
    }

    @Override
    protected void invalidateLayoutLocal() {
    }

    @Override
    public void paint(Graphics g) {
        Color over;
        TextImpl text;
        Collection words;
        RenderState rs = this.modelNode.getRenderState();
        String word = this.shownWord;
        int width = this.width;
        int ascentPlusLeading = this.ascentPlusLeading;
        int height = this.height;
        int textDecoration = rs.getTextDecorationMask();
        Color bkg = rs.getTextBackgroundColor();
        if (bkg != null) {
            Color oldColor = g.getColor();
            try {
                g.setColor(bkg);
                g.fillRect(0, 0, width, height);
            }
            finally {
                g.setColor(oldColor);
            }
        }
        if (this.modelNode instanceof TextImpl && (words = (text = (TextImpl)this.modelNode).getHiglightedWords()) != null) {
            for (String highlight : words) {
                int occurence = word.toUpperCase().indexOf(highlight.toUpperCase());
                if (occurence == -1) continue;
                int x1 = this.fontMetrics.stringWidth(word.substring(0, occurence));
                int x2 = this.fontMetrics.stringWidth(word.substring(0, occurence + highlight.length()));
                Color oldColor = g.getColor();
                try {
                    g.setColor(Color.YELLOW);
                    g.fillRect(x1, 0, x2 - x1, height);
                }
                finally {
                    g.setColor(oldColor);
                }
            }
        }
        g.drawString(word, 0, ascentPlusLeading);
        int td = textDecoration;
        if (td != 0) {
            if ((td & 1) != 0) {
                int lineOffset = ascentPlusLeading + 2;
                g.drawLine(0, lineOffset, width, lineOffset);
            }
            if ((td & 4) != 0) {
                FontMetrics fm = this.fontMetrics;
                int lineOffset = fm.getLeading() + (fm.getAscent() + fm.getDescent()) / 2;
                g.drawLine(0, lineOffset, width, lineOffset);
            }
            if ((td & 2) != 0) {
                FontMetrics fm = this.fontMetrics;
                int lineOffset = fm.getLeading();
                g.drawLine(0, lineOffset, width, lineOffset);
            }
        }
        if ((over = rs.getOverlayColor()) != null) {
            Color oldColor = g.getColor();
            try {
                g.setColor(over);
                g.fillRect(0, 0, width, height);
            }
            finally {
                g.setColor(oldColor);
            }
        }
    }

    @Override
    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        int w;
        int len;
        FontMetrics fm;
        int startX = -1;
        int endX = -1;
        if (this == startPoint.renderable) {
            startX = startPoint.x;
        }
        if (this == endPoint.renderable) {
            endX = endPoint.x;
        }
        if (!inSelection && startX == -1 && endX == -1) {
            return false;
        }
        if (startX != -1 && endX != -1) {
            if (endX < startX) {
                int temp = startX;
                startX = endX;
                endX = temp;
            }
        } else if (startX != -1 && endX == -1 && inSelection) {
            endX = startX;
            startX = -1;
        } else if (startX == -1 && endX != -1 && !inSelection) {
            startX = endX;
            endX = -1;
        }
        int width1 = -1;
        int width2 = -1;
        char[] wordChars = this.shownWord.toCharArray();
        if (startX != -1) {
            width1 = 0;
            fm = this.fontMetrics;
            len = 0;
            while (len < wordChars.length) {
                w = fm.charsWidth(wordChars, 0, len);
                if (w > startX) break;
                width1 = w;
                ++len;
            }
        }
        if (endX != -1) {
            width2 = 0;
            fm = this.fontMetrics;
            len = 0;
            while (len < wordChars.length) {
                w = fm.charsWidth(wordChars, 0, len);
                if (w > endX) break;
                width2 = w;
                ++len;
            }
        }
        if (width1 != -1 || width2 != -1) {
            int startPaint = width1 == -1 ? 0 : width1;
            int endPaint = width2 == -1 ? this.width : width2;
            g.setColor(SELECTION_COLOR);
            g.setXORMode(SELECTION_XOR);
            g.fillRect(startPaint, 0, endPaint - startPaint, this.height);
            g.setPaintMode();
            return width2 == -1;
        }
        if (inSelection) {
            g.setColor(SELECTION_COLOR);
            g.setXORMode(SELECTION_XOR);
            g.fillRect(0, 0, this.width, this.height);
            g.setPaintMode();
        }
        return inSelection;
    }

    @Override
    public boolean extractSelectionText(StringBuffer buffer, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        int w;
        int len;
        FontMetrics fm;
        int startX = -1;
        int endX = -1;
        if (this == startPoint.renderable) {
            startX = startPoint.x;
        }
        if (this == endPoint.renderable) {
            endX = endPoint.x;
        }
        if (!inSelection && startX == -1 && endX == -1) {
            return false;
        }
        if (startX != -1 && endX != -1) {
            if (endX < startX) {
                int temp = startX;
                startX = endX;
                endX = temp;
            }
        } else if (startX != -1 && endX == -1 && inSelection) {
            endX = startX;
            startX = -1;
        } else if (startX == -1 && endX != -1 && !inSelection) {
            startX = endX;
            endX = -1;
        }
        int index1 = -1;
        int index2 = -1;
        char[] wordChars = this.shownWord.toCharArray();
        if (startX != -1) {
            index1 = 0;
            fm = this.fontMetrics;
            len = 0;
            while (len < wordChars.length) {
                w = fm.charsWidth(wordChars, 0, len);
                if (w > startX) break;
                index1 = len++;
            }
        }
        if (endX != -1) {
            index2 = 0;
            fm = this.fontMetrics;
            len = 0;
            while (len < wordChars.length) {
                w = fm.charsWidth(wordChars, 0, len);
                if (w > endX) break;
                index2 = len++;
            }
        }
        if (index1 != -1 || index2 != -1) {
            int startIndex = index1 == -1 ? 0 : index1;
            int endIndex = index2 == -1 ? wordChars.length : index2;
            buffer.append(wordChars, startIndex, endIndex - startIndex);
        } else if (inSelection) {
            buffer.append(wordChars);
            return true;
        }
        if (index1 != -1 && index2 != -1) {
            return false;
        }
        return !inSelection;
    }

    @Override
    public boolean onMouseClick(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseClick(me, event, x, y);
        }
        return true;
    }

    @Override
    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onDoubleClick(me, event, x, y);
        }
        return true;
    }

    @Override
    public boolean onMousePressed(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseDown(me, event, x, y);
        }
        return true;
    }

    @Override
    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseUp(me, event, x, y);
        }
        return true;
    }

    @Override
    public boolean onMouseDisarmed(MouseEvent event) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseDisarmed(me, event);
        }
        return true;
    }

    @Override
    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        return new RenderableSpot(this, x, y);
    }

    @Override
    public boolean isContainedByNode() {
        return true;
    }

    @Override
    public boolean onRightClick(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onContextMenu(me, event, x, y);
        }
        return true;
    }

    public String toString() {
        return "RWord[word=" + this.shownWord + "]";
    }
}

