/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.ArrayList;
import org.lobobrowser.html.domimpl.DescendentHTMLCollection;
import org.lobobrowser.html.domimpl.ElementFilter;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.HtmlLength;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.TableRenderState;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLTableCaptionElement;
import org.w3c.dom.html2.HTMLTableElement;
import org.w3c.dom.html2.HTMLTableSectionElement;

public class HTMLTableElementImpl
extends HTMLAbstractUIElement
implements HTMLTableElement {
    private HTMLTableCaptionElement caption;
    private HTMLTableSectionElement thead;
    private HTMLTableSectionElement tfoot;

    public HTMLTableElementImpl() {
        super("TABLE");
    }

    public HTMLTableElementImpl(String name) {
        super(name);
    }

    @Override
    public HTMLTableCaptionElement getCaption() {
        return this.caption;
    }

    @Override
    public void setCaption(HTMLTableCaptionElement caption) throws DOMException {
        this.caption = caption;
    }

    @Override
    public HTMLTableSectionElement getTHead() {
        return this.thead;
    }

    @Override
    public void setTHead(HTMLTableSectionElement tHead) throws DOMException {
        this.thead = tHead;
    }

    @Override
    public HTMLTableSectionElement getTFoot() {
        return this.tfoot;
    }

    @Override
    public void setTFoot(HTMLTableSectionElement tFoot) throws DOMException {
        this.tfoot = tFoot;
    }

    @Override
    public HTMLCollection getRows() {
        return new DescendentHTMLCollection(this, new ElementFilter("TR"), this.treeLock, false);
    }

    @Override
    public HTMLCollection getTBodies() {
        return new DescendentHTMLCollection(this, new ElementFilter("TBODY"), this.treeLock, false);
    }

    @Override
    public String getAlign() {
        return this.getAttribute("align");
    }

    @Override
    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    @Override
    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    @Override
    public void setBgColor(String bgColor) {
        this.setAttribute("bgcolor", bgColor);
    }

    @Override
    public String getBorder() {
        return this.getAttribute("border");
    }

    @Override
    public void setBorder(String border) {
        this.setAttribute("border", border);
    }

    @Override
    public String getCellPadding() {
        return this.getAttribute("cellpadding");
    }

    @Override
    public void setCellPadding(String cellPadding) {
        this.setAttribute("cellpadding", cellPadding);
    }

    @Override
    public String getCellSpacing() {
        return this.getAttribute("cellspacing");
    }

    @Override
    public void setCellSpacing(String cellSpacing) {
        this.setAttribute("cellspacing", cellSpacing);
    }

    @Override
    public String getFrame() {
        return this.getAttribute("frame");
    }

    @Override
    public void setFrame(String frame) {
        this.setAttribute("frame", frame);
    }

    @Override
    public String getRules() {
        return this.getAttribute("rules");
    }

    @Override
    public void setRules(String rules) {
        this.setAttribute("rules", rules);
    }

    @Override
    public String getSummary() {
        return this.getAttribute("summary");
    }

    @Override
    public void setSummary(String summary) {
        this.setAttribute("summary", summary);
    }

    @Override
    public String getWidth() {
        return this.getAttribute("width");
    }

    @Override
    public void setWidth(String width) {
        this.setAttribute("width", width);
    }

    public HtmlLength getHeightLength(int availHeight) {
        try {
            String heightText;
            AbstractCSS2Properties props = this.getCurrentStyle();
            String string = heightText = props == null ? null : props.getHeight();
            if (heightText == null) {
                return new HtmlLength(this.getAttribute("height"));
            }
            return new HtmlLength(HtmlValues.getPixelSize(heightText, this.getRenderState(), 0, availHeight));
        }
        catch (Exception err) {
            return null;
        }
    }

    public HtmlLength getWidthLength(int availWidth) {
        try {
            String widthText;
            AbstractCSS2Properties props = this.getCurrentStyle();
            String string = widthText = props == null ? null : props.getWidth();
            if (widthText == null) {
                return new HtmlLength(this.getAttribute("width"));
            }
            return new HtmlLength(HtmlValues.getPixelSize(widthText, this.getRenderState(), 0, availWidth));
        }
        catch (Exception err) {
            return null;
        }
    }

    @Override
    public HTMLElement createTHead() {
        Document doc = this.document;
        return doc == null ? null : (HTMLElement)doc.createElement("thead");
    }

    @Override
    public void deleteTHead() {
        this.removeChildren(new ElementFilter("THEAD"));
    }

    @Override
    public HTMLElement createTFoot() {
        Document doc = this.document;
        return doc == null ? null : (HTMLElement)doc.createElement("tfoot");
    }

    @Override
    public void deleteTFoot() {
        this.removeChildren(new ElementFilter("TFOOT"));
    }

    @Override
    public HTMLElement createCaption() {
        Document doc = this.document;
        return doc == null ? null : (HTMLElement)doc.createElement("caption");
    }

    @Override
    public void deleteCaption() {
        this.removeChildren(new ElementFilter("CAPTION"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLElement insertRow(int index) throws DOMException {
        Document doc = this.document;
        if (doc == null) {
            throw new DOMException(4, "Orphan element");
        }
        HTMLElement rowElement = (HTMLElement)doc.createElement("TR");
        Object object = this.treeLock;
        synchronized (object) {
            if (index == -1) {
                this.appendChild(rowElement);
                return rowElement;
            }
            ArrayList nl = this.nodeList;
            if (nl != null) {
                int size = nl.size();
                int trcount = 0;
                int i = 0;
                while (i < size) {
                    Node node = (Node)nl.get(i);
                    if ("TR".equalsIgnoreCase(node.getNodeName())) {
                        if (trcount == index) {
                            this.insertAt(rowElement, i);
                            return rowElement;
                        }
                        ++trcount;
                    }
                    ++i;
                }
            } else {
                this.appendChild(rowElement);
                return rowElement;
            }
        }
        throw new DOMException(1, "Index out of range");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow(int index) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl = this.nodeList;
            if (nl != null) {
                int size = nl.size();
                int trcount = 0;
                int i = 0;
                while (i < size) {
                    Node node = (Node)nl.get(i);
                    if ("TR".equalsIgnoreCase(node.getNodeName())) {
                        if (trcount == index) {
                            this.removeChildAt(i);
                            return;
                        }
                        ++trcount;
                    }
                    ++i;
                }
            }
        }
        throw new DOMException(1, "Index out of range");
    }

    @Override
    protected RenderState createRenderState(RenderState prevRenderState) {
        return new TableRenderState(prevRenderState, this);
    }
}

