/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.style.CSSUtilities;
import org.lobobrowser.html.style.ColorRenderState;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.TextDecorationRenderState;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.html2.HTMLBodyElement;
import org.w3c.dom.html2.HTMLDocument;
import org.w3c.dom.html2.HTMLLinkElement;

public class HTMLLinkElementImpl
extends HTMLAbstractUIElement
implements HTMLLinkElement {
    private static final Logger logger = Logger.getLogger(HTMLLinkElementImpl.class.getName());
    private static final boolean loggableInfo = logger.isLoggable(Level.INFO);
    private CSSStyleSheet styleSheet;
    private boolean disabled;

    public HTMLLinkElementImpl(String name) {
        super(name);
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        CSSStyleSheet sheet = this.styleSheet;
        if (sheet != null) {
            sheet.setDisabled(disabled);
        }
    }

    @Override
    public String getHref() {
        String href = this.getAttribute("href");
        return href == null ? "" : href;
    }

    @Override
    public void setHref(String href) {
        this.setAttribute("href", href);
    }

    @Override
    public String getHreflang() {
        return this.getAttribute("hreflang");
    }

    @Override
    public void setHreflang(String hreflang) {
        this.setAttribute("hreflang", hreflang);
    }

    @Override
    public String getMedia() {
        return this.getAttribute("media");
    }

    @Override
    public void setMedia(String media) {
        this.setAttribute("media", media);
    }

    @Override
    public String getRel() {
        return this.getAttribute("rel");
    }

    @Override
    public void setRel(String rel) {
        this.setAttribute("rel", rel);
    }

    @Override
    public String getRev() {
        return this.getAttribute("rev");
    }

    @Override
    public void setRev(String rev) {
        this.setAttribute("rev", rev);
    }

    @Override
    public String getTarget() {
        String target = this.getAttribute("target");
        if (target != null) {
            return target;
        }
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        return doc == null ? null : doc.getDefaultTarget();
    }

    @Override
    public void setTarget(String target) {
        this.setAttribute("target", target);
    }

    @Override
    public String getType() {
        return this.getAttribute("type");
    }

    @Override
    public void setType(String type) {
        this.setAttribute("type", type);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if ("cobra.suspend".equals(key) && data != Boolean.TRUE) {
            this.processLink();
        } else if ("styleSheet.disabled.changed".equals(key)) {
            this.informDocumentInvalid();
        }
        return super.setUserData(key, data, handler);
    }

    protected void processLink() {
        this.styleSheet = null;
        String rel = this.getAttribute("rel");
        if (rel != null) {
            String media;
            UserAgentContext uacontext;
            String cleanRel = rel.trim().toLowerCase();
            boolean isStyleSheet = cleanRel.equals("stylesheet");
            boolean isAltStyleSheet = cleanRel.equals("alternate stylesheet");
            if ((isStyleSheet || isAltStyleSheet) && (uacontext = this.getUserAgentContext()).isExternalCSSEnabled() && CSSUtilities.matchesMedia(media = this.getMedia(), uacontext)) {
                HTMLDocumentImpl doc = (HTMLDocumentImpl)this.getOwnerDocument();
                try {
                    boolean liflag = loggableInfo;
                    long time1 = liflag ? System.currentTimeMillis() : 0L;
                    try {
                        CSSStyleSheet sheet = CSSUtilities.parse(this, this.getHref(), doc, doc.getBaseURI(), false);
                        if (sheet != null) {
                            this.styleSheet = sheet;
                            if (sheet instanceof CSSStyleSheetImpl) {
                                CSSStyleSheetImpl sheetImpl = (CSSStyleSheetImpl)sheet;
                                if (isAltStyleSheet) {
                                    sheetImpl.setDisabledOnly(true);
                                } else {
                                    sheetImpl.setDisabledOnly(this.disabled);
                                }
                            } else if (isAltStyleSheet) {
                                sheet.setDisabled(true);
                            } else {
                                sheet.setDisabled(this.disabled);
                            }
                            doc.addStyleSheet(sheet);
                        }
                    }
                    finally {
                        if (liflag) {
                            long time2 = System.currentTimeMillis();
                            logger.info("processLink(): Loaded and parsed CSS (or attempted to) at URI=[" + this.getHref() + "] in " + (time2 - time1) + " ms.");
                        }
                    }
                }
                catch (MalformedURLException mfe) {
                    this.warn("Will not parse CSS. URI=[" + this.getHref() + "] with BaseURI=[" + doc.getBaseURI() + "] does not appear to be a valid URI.");
                }
                catch (Throwable err) {
                    this.warn("Unable to parse CSS. URI=[" + this.getHref() + "].", err);
                }
            }
        }
    }

    public String getAbsoluteHref() {
        String href;
        HtmlRendererContext rcontext = this.getHtmlRendererContext();
        if (rcontext != null && (href = this.getHref()) != null && href.length() > 0) {
            String target = this.getTarget();
            try {
                URL url = this.getFullURL(href);
                return url == null ? null : url.toExternalForm();
            }
            catch (MalformedURLException mfu) {
                this.warn("Malformed URI: [" + href + "].", mfu);
            }
        }
        return null;
    }

    public void navigate() {
        String href;
        if (this.disabled) {
            return;
        }
        HtmlRendererContext rcontext = this.getHtmlRendererContext();
        if (rcontext != null && (href = this.getHref()) != null && href.length() > 0) {
            String target = this.getTarget();
            try {
                URL url = this.getFullURL(href);
                if (url == null) {
                    this.warn("Unable to resolve URI: [" + href + "].");
                } else {
                    rcontext.linkClicked(this, url, target);
                }
            }
            catch (MalformedURLException mfu) {
                this.warn("Malformed URI: [" + href + "].", mfu);
            }
        }
    }

    private Color getLinkColor() {
        HTMLBodyElement body;
        HTMLDocument doc = (HTMLDocument)this.document;
        if (doc != null && (body = (HTMLBodyElement)doc.getBody()) != null) {
            HtmlRendererContext rcontext;
            String vlink = body.getVLink();
            String link = body.getLink();
            if ((vlink != null || link != null) && (rcontext = this.getHtmlRendererContext()) != null) {
                String colorText;
                boolean visited = rcontext.isVisitedLink(this);
                String string = colorText = visited ? vlink : link;
                if (colorText != null) {
                    return ColorFactory.getInstance().getColor(colorText);
                }
            }
        }
        return Color.BLUE;
    }

    @Override
    protected RenderState createRenderState(RenderState prevRenderState) {
        if (this.hasAttribute("href")) {
            prevRenderState = new TextDecorationRenderState(prevRenderState, 1);
            prevRenderState = new ColorRenderState(prevRenderState, this.getLinkColor());
        }
        return super.createRenderState(prevRenderState);
    }

    @Override
    public String toString() {
        return this.getHref();
    }
}

