/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class XmlFormatter {
    public static final String format(Node node) {
        Document doc = node.getOwnerDocument();
        if (doc == null && node instanceof Document) {
            doc = (Document)node;
        }
        DOMImplementation impl = doc.getImplementation();
        DOMImplementationLS implLS = (DOMImplementationLS)impl.getFeature("LS", "3.0");
        LSSerializer lsSerializer = implLS.createLSSerializer();
        lsSerializer.setNewLine("\n");
        lsSerializer.getDomConfig().setParameter("xml-declaration", true);
        lsSerializer.getDomConfig().setParameter("format-pretty-print", true);
        SerializerOutput serializer = new SerializerOutput();
        lsSerializer.write(node, serializer);
        return serializer.toString();
    }

    private static final class SerializerOutput
    implements LSOutput {
        private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();

        private SerializerOutput() {
        }

        @Override
        public OutputStream getByteStream() {
            return this.bytes;
        }

        @Override
        public Writer getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return "UTF-8";
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public void setByteStream(OutputStream byteStream) {
        }

        @Override
        public void setCharacterStream(Writer characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setSystemId(String systemId) {
        }

        public String toString() {
            try {
                return new String(this.bytes.toString("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

