/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.util;

public class XMLEscaper {
    public static final CharSequence escapeAttribute(CharSequence input) {
        StringBuilder result = new StringBuilder(input.length() + 32);
        block4: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\'': {
                    result.append("&apos;");
                    continue block4;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block4;
                }
                default: {
                    XMLEscaper.escapeChar(result, input.charAt(i));
                }
            }
        }
        return result;
    }

    public static CharSequence escapeCharData(CharSequence input) {
        StringBuilder result = new StringBuilder(input.length() + 32);
        for (int i = 0; i < input.length(); ++i) {
            XMLEscaper.escapeChar(result, input.charAt(i));
        }
        return result;
    }

    private static void escapeChar(StringBuilder result, char c) {
        switch (c) {
            case '&': {
                result.append("&amp;");
                break;
            }
            case '<': {
                result.append("&lt;");
                break;
            }
            case '>': {
                result.append("&gt;");
                break;
            }
            default: {
                if (!(c >= ' ' && c <= '\u007f' || Character.isWhitespace(c))) {
                    result.append("&#x" + Integer.toString(c, 16) + ";");
                    break;
                }
                result.append(c);
            }
        }
    }
}

